#!/bin/bash
SCRIPT_FULL_PATH=`readlink -f $0`
CUR_DIR=`dirname ${SCRIPT_FULL_PATH}`
source ${CUR_DIR}/util.sh

component=$1
dcm=$2
if [[ "$1" == "operation" ]];then
    component="${component}engine"
fi

# 配置karbor
if [ ${dcm} -eq 1 ];then
    /usr/bin/cp -f /opt/huawei/dj/cfg/karbor.conf /etc/karbor/karbor.conf
    if [ $? != 0 ];then
        log_error "copy karbor.conf failed!"
        exit 1
    fi
fi
sed -i "s/process-name/${component}/g" /etc/karbor/karbor.conf
csbs_python /installfiles/comp/karbor/config.py
if [ $? -ne 0 ];then
    log_error "Config karbor failed, error code is $?"
    exit $?
fi
if [ ${dcm} -eq 0 ];then
    csbs_python /installfiles/syncsys/karbor_watcher.py sync
    if [ $? != 0 ];then
        log_error "cms_watcher init failed!"
        exit 1
    fi
fi
if [[ "${component}" == "api" ]]; then
    kangaroo-manage --config-file=/etc/karbor/karbor.conf db_sync
fi

# 启动karbor
while true;do
    if [ ${dcm} -eq 0 ];then
        cms_component_num=`pgrep -f /installfiles/syncsys/karbor_watcher.py`
        if [[ -z "${cms_component_num}" ]];then
            log_warn "karbor_watcher crashed and restart karbor_watcher"
            proc_manager --start /installfiles/syncsys/karbor_watcher.py
        fi
    fi
    karbor-${component}Control -CS CompontState
    if [ $? -ne 0 ];then
        log_warn "karbor${component} stopped, try to restart."
        karbor-${component}Control -A RESTART
    fi
    if [[ "${component}" == "api" ]]; then
        component_num=$(pgrep -f /usr/bin/operation-register)
        if [[ -z "${component_num}" ]];then
            log_warn "operation_register componentess stopped, try to restart."
            proc_manager --start /usr/bin/operation-register
        fi
    fi
    sleep 10
done
