
# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: inspect_item
# Description: Entrance of this scripts
# Parameter:
# Return: success 0, fail 1
# **************************************************************************** #
inspect_item()
{
    case $1 in
    karbor_api_process)
        check_karbor_api;;
    karbor_protection_process)
        check_karbor_protection;;
    karbor_operationengine_process)
        check_karbor_operationengine;;
    service_status)
        check_service_status;;
    karbor_docking_status)
        check_karbor_docking_status;;
    docker_status)
        check_docker_status;;
    esac
}

check_karbor_api()
{
    # Check if the karbor-api process exists
    line=`ps -ef|grep "/usr/bin/karbor-api"|grep -v "grep"|wc -l`
    if [ $line -eq 0 ]
    then
        exit 1
    else
        exit 0
    fi
}

check_karbor_protection()
{
    # Check if the karbor-protection process exists
    line=`ps -ef|grep "/usr/bin/karbor-protection"|grep -v "grep"|wc -l`
    if [ $line -eq 0 ]
    then
        exit 1
    else
        exit 0
    fi
}

check_karbor_operationengine()
{
    # Check if the karbor-operationengine process exists
    line=`ps -ef|grep "/usr/bin/karbor-operationengine"|grep -v "grep"|wc -l`
    if [ $line -eq 0 ]
    then
        exit 1
    else
        exit 0
    fi
}

check_service_status()
{
    # omm-ha are active and standby
    node_name=`get_info.py --hostname`
    fault_service=`show_service --node $node_name |grep "fault"|grep -v "license"|wc -l`
    if [ $fault_service -gt 0 ]
    then
        exit 1
    else
        active_ret=`show_service --service omm-ha |grep "active" |wc -l`
        standby_ret=`show_service --service omm-ha |grep "standby" |wc -l`
        if [ $standby_ret -ne 1 ] || [ $active_ret -ne 1 ];then
            exit 1
        fi
        exit 0
    fi
}

check_karbor_docking_status()
{
    # Check if the karbor docking status is normal, using check_karbor_connect
    # According to the CTS switch status to judge docking status of cts
    check_karbor_connect >/dev/null 2>&1
    ret=$?
    if [ $ret -ne 0 ];then
        exit 1
    fi
    error_dock=`check_karbor_connect |grep "Error" | wc -l`
    if [ ${error_dock} -gt 0 ];then
        exit 1
    else
        exit 0
    fi
}

check_docker_status()
{
    # Check if the docker of each service is running, using docker inspect
    docker_comps=`docker ps -a -q`
    for docker_comp in ${docker_comps[@]}
    do
        docker_status=`docker inspect $docker_comp | grep "Status"`
        status=`echo $docker_status | cut -d \" -f 4`
        if [ "${status}" != "running" ];then
            exit 1
        fi
    done

}

inspect_item $*
