#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
SERV_IMG_NAME="karbor"
SERV_IMG_VERSION=`read_microservice_ver ${LINE_ROOT}/services/karbor/karbor.ver`
BASE_IMG_VERSION=`read_microservice_ver ${LINE_ROOT}/services/base/base.ver`

log_info "Begin to merge and load karbor."
LOG_DIR=/var/log/huawei/dj/services/system/karbor/
if [[ ! -d ${LOG_DIR} ]]; then
    mkdir -p ${LOG_DIR}
fi

img_nums=`docker images -q ${SERV_IMG_NAME}:${SERV_IMG_VERSION} | wc -l`
if [ ${img_nums} -gt 0 ];then
    log_error "Found same version image [${SERV_IMG_NAME}:${SERV_IMG_VERSION}] in local repository."
    exit 1
fi

function docker_build()
{
    log_info "Execute docker build"
    docker build --force-rm=true -t ${SERV_IMG_NAME}:${SERV_IMG_VERSION} ${CURRENT_PATH}
    return $?
}

function make_image()
{
    log_info "Begin to execute docker build..."
    /usr/bin/cp -f ${LINE_ROOT}/repo/self_developed/{kangaroo-*.whl,karbor-*.whl} ${CURRENT_PATH}/installfiles
    CHECK_RESULT $? "Can not find kangaroo and karbor package."
    replace_variable BASE_IMG_VERSION "${LINE_ROOT}/services/karbor/Dockerfile"
    cmd_retry "docker_build" "3" "3"
    img_nums=`docker images -q ${SERV_IMG_NAME}:${SERV_IMG_VERSION} | wc -l`
    if [ ${img_nums} -eq 0 ];then
        log_error "Build image [${SERV_IMG_NAME}:${SERV_IMG_VERSION}] failed."
        exit 1
    fi
    log_info "Execute karbor build finished."
}

make_image
log_info "Merge and load karbor successfully."
exit 0
