#!/bin/bash
if [ ${UID} -ne 0 ];then
    sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

source /opt/huawei/dj/inst/bin/utils.sh
KARBOR_LOG_PATH="/var/log/huawei/dj/services/system/karbor"
LOG_FILE="${KARBOR_LOG_PATH}/karbor-run.log"
profile=`csbs_python /usr/bin/get_info.py --profile`
DMK_A_CMD="rm -rf /usr/bin/sendAlarm && ln -s /opt/ServiceOM/omm/oma/tools/sendAlarm /usr/bin/sendAlarm"
DMK_A4_CMD="rm -rf /usr/bin/sendAlarm4Iaas && ln -s /opt/ServiceOM/omm/oma/tools/sendAlarm4Iaas /usr/bin/sendAlarm4Iaas"
CLA_A_CMD="rm -rf /usr/bin/sendAlarm && ln -s /usr/local/CloudAgent/plugins/CloudAlarm/tools/sendAlarm /usr/bin/sendAlarm"
CLA_A4_CMD="rm -rf /usr/bin/sendAlarm4Iaas && ln -s /usr/local/CloudAgent/plugins/CloudAlarm/tools/sendAlarm4Iaas /usr/bin/sendAlarm4Iaas"
SERV_IMG_VERSION=$(read_microservice_ver /opt/huawei/dj/versions/karbor.ver)
HOST_IP=$(get_info.py manage_ip)
FORCE=0
DCM=0

function get_component_name()
{
    pid=$$
    component_name=""
    while [[ ${component_name} == "" && ${pid} != 0 ]]
    do
        line=$(ps -wweo pid,ppid,uname,args | grep "^[[:space:]]*${pid}[[:space:]]")
        if [ -z "$line" ]; then
           break
        fi
        pid=$(echo $line | awk '{print $2}')
        component_name=`echo ${line} | grep -o "karbor-.*Control" | sed -r "s/karbor-(.*)Control/\1/g"`
    done
    echo ${component_name}
}

function has_container()
{
    container_num=`docker ps -a | grep karbor${component} | wc -l`
    if [[ ${container_num} -ge 1 ]];then
        return 0
    fi
    return 1
}

function has_running_container()
{
    container_num=`docker ps|grep karbor${component} | wc -l`
    if [[ ${container_num} -ge 1 ]];then
       return 0
    fi
    return 1
}

function remove_container()
{
    has_container
    if [ $? -ne 0 ];then
        log_info "Container for ${component} not exist and can not remove"
        return 1
    fi
    local retry=0
    while [[ ${retry} -lt 3 ]]
    do
        log_info "Remove container for ${component}."
        echo "Remove container for ${component}."
        docker rm -f karbor${component} > /dev/null 2>&1
        if [[ $? -eq 0 ]];then
            log_info "Remove ${component} container successfully."
            echo "Remove ${component} container successfully."
            return 0
        fi
        log_info "Remove ${component} container failed, retry."
        retry=$(( ${retry} + 1 ))
    done
    log_error "Remove ${component} container failed."
    return 1
}

function stop_container()
{
    has_running_container
    if [ $? -ne 0 ];then
        log_info "Container for ${component} not running and can not stop"
        return 1
    fi
    local retry=0
    while [[ ${retry} -lt 3 ]]
    do
        log_info "Stop container for ${component}."
        echo "Stop container for ${component}."
        docker stop karbor${component} > /dev/null 2>&1
        if [[ $? -eq 0 ]];then
            log_info "Stop ${component} container successfully."
            echo "Stop ${component} container successfully."
            return 0
        fi
        log_info "Stop ${component} container failed, retry."
        retry=$(( ${retry} + 1 ))
    done
    log_error "Stop ${component} container failed."
    return 1
}

function start_container()
{
    local retry=0
    while [[ ${retry} -lt 3 ]]
    do
        log_info "Start container for ${component}."
        echo "Start container for ${component}."
        docker start karbor${component} > /dev/null 2>&1
        if [[ $? -eq 0 ]];then
            log_info "Start ${component} container successfully."
            echo "Start ${component} container successfully."
            return 0
        fi
        log_info "Start ${component} container failed, retry."
        retry=$(( ${retry} + 1 ))
    done
    log_error "Start ${component} container failed."
    return 1
}

function run_component()
{
    docker run -d  --cpu-shares 1024  --security-opt=no-new-privileges --ipc=host \
    -v /usr/bin/get_info.py:/usr/bin/get_info.py:ro \
    -v /opt/huawei/dj/cfg:/opt/huawei/dj/cfg:ro \
    -v /opt/huawei/dj/DJSecurity:/opt/huawei/dj/DJSecurity \
    -v /etc/localtime:/etc/localtime:ro \
    -v /etc/hosts:/etc/hosts:ro \
    -v /opt/huawei/dj/paas:/opt/huawei/dj/paas \
    -v /opt/omm/oma/tools:/opt/omm/oma/tools \
    -v /opt/ServiceOM:/opt/ServiceOM \
    -v /etc/profile.d/serviceom_omm_agent.sh:/etc/profile.d/serviceom_omm_agent.sh \
    -v /opt/karbor/data:/opt/karbor/data \
    -v /usr/local/CloudAgent/plugins/CloudAlarm:/usr/local/CloudAgent/plugins/CloudAlarm \
    -v /var/log/huawei/dj/services/system/karbor:/var/log/install \
    -v /var/log/huawei/dj/services/system/kmc:/var/log/huawei/dj/services/system/kmc \
    -v /opt/fusionplatform/data/openstack:/opt/fusionplatform/data/openstack \
    -v /var/log/huawei/dj/services/system/karbor:/var/log/karbor \
    -v /var/log/huawei/dj/services/operate:/var/log/operate \
    -p ${HOST_IP}:28799:28799 --memory 4000m --pids-limit 1024 --net=host --ulimit nofile=2048:2048\
    --name karbor${component} -e "HOST_IP=${HOST_IP}" karbor:${SERV_IMG_VERSION} sh /installfiles/run.sh ${component} ${DCM} >/dev/null 2>&1
    if [[ $? != 0 ]];then
        echo "Run docker for ${component} failed."
        log_error "Run docker for ${component} failed."
        return 1
    fi
    log_info "Run docker for ${component} successfully."
    echo "Run docker for ${component} successfully."
    return 0
}

function regist_heartBeat()
{
    heartBeat START karbor-${component}
    if [[ $? != 0 ]];then
        log_error "Register heartbeat for ${component} failed."
        echo "Register heartbeat for ${component} failed."
    fi
    karbor_ha_reg
    log_info "Register heartbeat for ${component} success."
    echo "Register heartbeat for ${component} success."
}

function stop_heartBeat()
{
    karbor_ha_unreg
    heartBeat STOP "karbor-${component}"
    if [[ $? != 0 ]];then
        log_error "Stop heartbeat for ${component} failed."
        echo "Stop heartbeat for ${component} failed."
    else
        log_info "Stop heartbeat for ${component} success."
        echo "Stop heartbeat for ${component} success."
    fi
}

function karbor_ha_reg()
{
    if [[ ! -f "/usr/bin/haproxy_regist" ]];then
        log_info "Haproxy register no exist, continue install"
        return 0
    fi
    if [[ ${component} != "api" ]];then
        return 0
    fi
    haproxy_num=$(pgrep -f /usr/sbin/haproxy | wc -l)
    if [[ ${haproxy_num} -eq 0 ]];then
        return 0
    fi
    haproxy_regist add --frontend-name karbor --plane internal --frontend-port 8799 --server-ip ${HOST_IP} --server-port 28799
    if [[ $? != 0 ]];then
        log_error "Haproxy register ${HOST_IP} failed."
        echo "Haproxy register ${HOST_IP} failed."
        return 1
    else
        log_info "Haproxy register ${HOST_IP} success."
        echo "Haproxy register ${HOST_IP} success."
        return 0
    fi
}

function karbor_ha_unreg()
{
    if [[ ! -f "/usr/bin/haproxy_regist" ]];then
        log_info "Haproxy register no exist, continue install"
        return 0
    fi
    if [[ ${component} != "api" ]];then
        return 0
    fi
    haproxy_num=$(pgrep -f /usr/sbin/haproxy | wc -l)
    if [[ ${haproxy_num} -eq 0 ]];then
        return 0
    fi
    haproxy_regist delete --frontend-name karbor --plane internal --frontend-port 8799 --backend-name default --server-ip ${HOST_IP} --server-port 28799
    if [[ $? != 0 ]];then
        log_error "Haproxy unregister ${HOST_IP} failed."
        echo "Haproxy unregister ${HOST_IP} failed."
    else
        log_info "Haproxy unregister ${HOST_IP} success."
        echo "Haproxy unregister ${HOST_IP} success."
    fi
}

function showhelp()
{
    usage="Usage: ${prog} "
    len=${#usage}
    echo "Usage: ${prog} [-S RUN]"
    printf "%-${len}s[-S STOP]\n"
    printf "%-${len}s[-F STOP]\n"
    printf "%-${len}s[-A RESTART]\n"
    printf "%-${len}s[-F RESTART]\n"
    printf "%-${len}s[-D RESTART]\n"
    printf "%-${len}s[-CS CompontState]\n"
    printf "%-${len}s[-h]\n"
    exit 1
}

function set_oma_link_private()
{
    docker exec -u root karbor${component} bash -c "${DMK_A_CMD}"
    docker exec -u root karbor${component} bash -c "${DMK_A4_CMD}"

    local omm=`cat /etc/passwd | grep omm`
    if [[ "${omm}" == "" ]];then
        return 0
    fi

    local gaussdba=`cat /etc/passwd | grep gaussdba`
    if [[ "${gaussdba}" == "" ]];then
        docker exec -u root karbor${component} bash -c "userdel gaussdba >/dev/null 2>&1"
        docker exec -u root karbor${component} bash -c "groupdel dbgrp >/dev/null 2>&1"
    fi

    docker exec -u root karbor${component} bash -c "cat /etc/passwd | grep omm >/dev/null 2>&1"
    if [[ $? -eq 0 ]]; then
        return 0
    fi

    local omm_user=`echo "${omm}" | cut -f3 -d':'`
    local omm_group=`echo "${omm}" | cut -f4 -d':'`
    docker exec -u root karbor${component} bash -c "groupadd -g ${omm_group} omm"
    docker exec -u root karbor${component} bash -c "useradd -u ${omm_user} -g ${omm_group} omm"
    docker exec -u root karbor${component} bash -c "usermod -a -G omm openstack"
    stop_container
    start_container
}

function set_oma_link_public()
{
    # Add link for omm agent in advance
    if [[ -f /opt/ServiceOM/omm/oma/tools/sendAlarm ]]; then
        docker exec -u root karbor${component} bash -c "${DMK_A_CMD}"
    elif [[ -f /usr/local/CloudAgent/plugins/CloudAlarm/tools/sendAlarm ]]; then
        docker exec -u root karbor${component} bash -c "${CLA_A_CMD}"
    fi
    if [[ -f /opt/ServiceOM/omm/oma/tools/sendAlarm4Iaas ]]; then
        docker exec -u root karbor${component} bash -c "${DMK_A4_CMD}"
    elif [[ -f /usr/local/CloudAgent/plugins/CloudAlarm/tools/sendAlarm4Iaas ]]; then
        docker exec -u root karbor${component} bash -c "${CLA_A4_CMD}"
    fi
}

function component_run()
{
    log_info "Run ${component} begin"
    has_running_container
    if [ $? -eq 0 ];then
        echo "${component} is running."
        log_info "Run ${component} end."
        return 0
    fi
    has_container
    if [ $? -eq 0 ];then
        start_container
    else
        run_component
    fi
    has_running_container
    CHECK_RESULT $? "Start ${component} failed."
    regist_heartBeat
    if [[ "${profile}" == "public" ]];then
        set_oma_link_public
    else
        set_oma_link_private
    fi
    echo "Start ${component} successfully"
    log_info "Run ${component} end"
}

function component_stop()
{
    log_info "Stop ${component} endbegin"
    stop_heartBeat
    if [[ "${FORCE}" -eq "1" ]];then
        remove_container
    else
        stop_container
    fi
    echo "Stop ${component} successfully."
    log_info "Stop ${component} end"
}


function component_restart()
{
    log_info "${component} restart begin."
    component_stop
    component_run $1
    log_info "${component} restart end."
}


function component_statusget()
{
    has_running_container
    if [ $? -ne 0 ];then
        return 1
    fi
    if [[ "${component}" == "operation" ]];then
        proc_name="operationengine"
    else
        proc_name="${component}"
    fi
    docker exec karbor${component} karbor-${proc_name}Control -CS CompontState
    return $?
}

function args_err()
{
    echo -e "${prog}: illegal option"
    showhelp
}

function chown_chmod_log_dir()
{
    mkdir -p ${KARBOR_LOG_PATH}/export_log >/dev/null 2>&1
    chown -h openstack:openstack  ${KARBOR_LOG_PATH} >/dev/null 2>&1
    chown -h openstack:openstack  ${KARBOR_LOG_PATH}/export_log >/dev/null 2>&1
    su -s /bin/sh openstack -c "chmod 750 ${KARBOR_LOG_PATH} >/dev/null 2>&1"
    su -s /bin/sh openstack -c "chmod 750 ${KARBOR_LOG_PATH}/export_log >/dev/null 2>&1"
}

log_info "INFO | #################begin exec karborControl########################."
chown_chmod_log_dir
component=`get_component_name`
if [[ ${component} == "" ]];then
    log_error "get component name failed."
    exit 1
fi
case "$1 '$2' $#" in
    "-S 'RUN' 2")
        ServiceState=$2
        ;;
    "-S 'STOP' 2")
        ServiceState=$2
        ;;
    "-F 'STOP' 2")
        FORCE=1
        ServiceState=$2
        ;;
    "-A 'RESTART' 2")
        Action=$2
        ;;
    "-F 'RESTART' 2")
        FORCE=1
        Action=$2
        ;;
    "-D 'RESTART' 2")
        DCM=1
        FORCE=1
        Action=$2
        ;;
    "-CS 'CompontState' 2")
        CompStatus=$2
        ;;
    "-h '' 1")
        showhelp
        ;;
    *)
        args_err
        break
        ;;
esac

if [[ "RESTART" == "${Action}" ]]; then
    (
        flock -n 211
        [[ $? -eq 1 ]] && { echo "${component}Control is already running";exit 1;}
        component_restart
    )211<>/tmp/${component}Control.lock
elif [[ "RUN" == "${ServiceState}" ]]; then
    (
        flock -n 211
        [[ $? -eq 1 ]] && { echo "${component}Control is already running";exit 1;}
        component_run
    )211<>/tmp/${component}Control.lock
elif [[ "STOP" == "${ServiceState}" ]]; then
    (
        flock -n 211
        [[ $? -eq 1 ]] && { echo "${component}Control is already running";exit 1;}
        component_stop
    )211<>/tmp/${component}Control.lock
elif [[ "CompontState" == "${CompStatus}" ]]; then
    component_statusget
fi
exit $?