#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/omm-ha_upgrade.log"
source ${CURRENT_DIR}/util_omm-ha.sh

function rollback_files()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ "$?" -ne "0" ];then
        log_error "Rollback omm-ha files failed."
        return 1
    fi
    log_info "Rollback omm-ha files success."
    return 0
}

function main()
{
    omm-haControl -S STOP >/dev/null 2>&1
    rollback_files; CHECK_RESULT $?
    omm-haControl -S RUN
}

main
sed -i '/^omm-ha$/d' ${LINE_ROOT}/should_rollback.dat
log_info "rollback omm-ha success."
exit 0
