#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/omm-ha_upgrade.log"
OMM_HA_PLUGIN_SCRIPT="/usr/local/bin/ha/ha/module/harm/plugin/script/"
source ${CURRENT_DIR}/util_omm-ha.sh

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ "$?" -ne "0" ];then
        log_error "backup omm-ha failed."
        return 1
    fi
    log_info "backup omm-ha success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write omm-ha
    if [ $? -ne 0 ];then
        log_error "failed to write omm-ha upgrade flag"
        return 1
    fi
    log_info "success to write omm-ha upgrade flag."
    return 0
}

function main()
{
    backup_files; CHECK_RESULT $?
    set_upgrade_flag
    cmd_retry "omm-haControl -S STOP" 60 5 >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "Stop omm-ha failed."
        exit 1
    fi
    log_info "stop omm-ha success."
    tar cvfpP ${CURRENT_DIR}/backup_files/plugin.tar.gz /usr/local/bin/ha/ha/module/harm/plugin /usr/local/bin/ha/ha/config_script>/dev/null 2>&1
    sh ${CURRENT_DIR}/../uninstall.sh
    sh ${CURRENT_DIR}/../install.sh
    if [ $? -ne 0 ];then
        log_error "failed to install new omm-ha"
        exit 1
    fi
    sleep 3
    tar xvfpP ${CURRENT_DIR}/backup_files/plugin.tar.gz >/dev/null 2>&1
    sh ${CURRENT_DIR}/../config.sh
    if [ $? -ne 0 ];then
        log_error "failed to config new omm-ha"
        exit 1
    fi
    sleep 3
    sudo_cmd="1aif [ \${UID} -ne 0 ];then\n  sudo \$(dirname \$(readlink -f \$0))\/\$(basename \$(readlink -f \$0)) \$@;exit \$?\nfi"
    gaussdb_sudo_flag=`grep 'sudo \$(dirname' ${OMM_HA_PLUGIN_SCRIPT}/gaussdb.sh`
    if [[ "${gaussdb_sudo_flag}" = "" ]];then
      sed -i "${sudo_cmd}" ${OMM_HA_PLUGIN_SCRIPT}/gaussdb.sh
    fi
    floatIp_sudo_flag=`grep 'sudo \$(dirname' ${OMM_HA_PLUGIN_SCRIPT}/floatIp.sh`
    if [[ "${floatIp_sudo_flag}" = "" ]];then
      sed -i "${sudo_cmd}" ${OMM_HA_PLUGIN_SCRIPT}/floatIp.sh
    fi
    hafloatIp_sudo_flag=`grep 'sudo \$(dirname' ${OMM_HA_PLUGIN_SCRIPT}/hafloatIp.sh`
    if [[ "${hafloatIp_sudo_flag}" = "" ]];then
      sed -i "${sudo_cmd}" ${OMM_HA_PLUGIN_SCRIPT}/hafloatIp.sh
    fi
    sh ${CURRENT_DIR}/../start.sh
    if [ $? -ne 0 ];then
        log_error "failed to start new omm-ha"
        exit 1
    fi
}
main
log_info "upgrade omm-ha success."
exit 0