#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
CLUSTER_IP_LIST=($(get_info.py rabbitmq_nodes list | sed 's/,/ /g'))

function _setrabbitmq_conf()
{
    for node in ${CLUSTER_IP_LIST[@]};do
        local host_name="mq${node//./}"
        host_name=${host_name//:/} #IPV6
        local old_info=`cat /etc/hosts 2>/dev/null | awk '{if ($2==name) print}' name=${host_name}`
        if [ "${old_info}" = "" ];then
            echo "${node} ${host_name}">>"/etc/hosts"
        else
            sed -i "s/${old_info}/${node} ${host_name}/"  "/etc/hosts" 2>/dev/null
        fi
        log_info "Set rabbitmq hosts[${host_name}] successfully."
    done
    return 0
}

_setrabbitmq_conf
exit 0