#!/bin/bash
#check rabbitmq service cluster status
source /usr/local/lib/rabbitmq/HW_FS_Extend/etc/safe_config.sh

# 检查当前节点是否正在运行，未运行则进行重启
${RABBITMQCTL_PATH} cluster_status
if [[ $? -ne 0 ]];then
    log_error "Current node status is stop, need to start it."
    restart_rabbitmq
fi

# rabbitmq集群配置为默认值，无需添加集群
cat ${RABBITMQ_CFG_PATH} | grep "rabbit@rabbitmqNode0, rabbit@rabbitmqNode1"
if [[ $? -eq 0 ]];then
    log_info "One node no need to join cluster."
    exit 0
fi

# rabbitmq配置缺失当前节点名称，无法添加集群
cur_node_name=`cat ${RABBITMQ_ENV_PATH} | grep "RABBITMQ_NODENAME" | awk  -F '='  '{print $2}' | grep -v "^$"`
if [[ "${cur_node_name}" == "" ]];then
    log_error "Cannot get RABBITMQ_NODENAME from conf."
    exit 1
fi

# rabbitmq配置缺失当前节点集群信息，无法添加集群
cluster_info=`cat ${RABBITMQ_CFG_PATH} | grep "${cur_node_name}" | awk  -F '['  '{print $2}'| awk  -F ']'  '{print $1}'`
if [[ "${cluster_info}" == "" ]];then
    log_error "Cannot get CLUSTER_INFO from conf."
    exit 1
fi

# 当前节点为集群首节点，无需添加集群
clusters=($(echo ${cluster_info} | sed 's/,/ /g'))
if [[ "${cur_node_name}" == "${clusters[0]}" ]];then
    log_info "This current node is cluster name, not need join cluster."
    exit 0
fi

# 集群节点中仅包含当前节点则当前节点尚未加入集群，反之，当前节点已经存在集群，无需添加集群
${RABBITMQCTL_PATH} cluster_status > /usr/local/lib/rabbitmq/cluster_info.txt
running_nodes_line_number=`grep -n "Running Nodes" cluster_info.txt | cut -d : -f 1`
version_line_number=`grep -n "Versions" cluster_info.txt | cut -d : -f 1`
nodes=`awk -v s="${running_nodes_line_number}" -v e="${version_line_number}" 'NR>s&&NR<e' cluster_info.txt | grep -v "^$"`
if [[ "${nodes}" != "${cur_node_name}" ]];then
    log_info "The current node is in the cluster."
    rm -f /usr/local/lib/rabbitmq/cluster_info.txt
    exit 0
fi
rm -f /usr/local/lib/rabbitmq/cluster_info.txt

# 加入首节点所在的集群
join_cluster "${clusters[0]}"
if [[ $? -ne 0 ]];then
   log_info "Join cluster failed."
   exit 1
fi
log_info "Join cluster success."
exit 0