#!/usr/bin/csbs_python
import secrets
import threading
import time

from basesdk import kazooClient
from basesdk import utils
from basesdk.cms_info import CMS_ROOT_NODE

LOG = utils.get_logger("rabbitmq_watch")
RABBIT_CFG = 'rabbitmq.pwd'
CTL_PATH = '/usr/local/lib/rabbitmq/HW_FS_Extend/etc'


class RabbitWatcher(threading.Thread):
    def __init__(self):
        super(RabbitWatcher, self).__init__()
        self.zk_client = None
        self.register_rabbitmq = False
        self.start()

    @staticmethod
    def rabbitmq_hook(info):
        comp_info = info.decode()
        LOG.info("Key: %s. Value %s " % (RABBIT_CFG, comp_info))
        result, _ = utils.run_cmd(
            ['csbs_python', "%s/modify_password.py" % CTL_PATH])
        if result != 0:
            LOG.error("Exec cmd changepwd rabbit failed.")

    def run(self):
        while 1:
            try:
                if not self.zk_client:
                    self.zk_client = kazooClient.get_zk_client_start(
                        utils.get_zk_ip())
                    node_path = '/'.join([CMS_ROOT_NODE, RABBIT_CFG])
                    kazooClient.register_data_watch(
                        self.zk_client, node_path, self.rabbitmq_hook)
            except Exception:
                LOG.error("Register data watch failed")
            utils.run_cmd(['bash', "%s/check_cluster.sh" % CTL_PATH])
            time.sleep(secrets.SystemRandom().randint(60, 240))


RabbitWatcher()
