#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
SERV_IMG_NAME="rabbitmq"
SERV_IMG_VERSION=`read_microservice_ver ${LINE_ROOT}/services/rabbitmq/rabbitmq.ver`
BASE_IMG_VERSION=`read_microservice_ver ${LINE_ROOT}/services/base/base.ver`
CLUSTER_IP_LIST=($(get_info.py rabbitmq_nodes list |sed 's/,/ /g'))
LOCAL_IP=$(get_info.py manage_ip)
RABBITMQ_ENV_PATH=${LINE_ROOT}/services/rabbitmq/images/installfiles/rabbitmq-env.conf
RABBITMQ_CFG_PATH=${LINE_ROOT}/services/rabbitmq/images/installfiles/rabbitmq.config
img_nums=`docker images -q ${SERV_IMG_NAME}:${SERV_IMG_VERSION} | wc -l`
if [ ${img_nums} -gt 0 ];then
    log_error "Found same version image [${SERV_IMG_NAME}:${SERV_IMG_VERSION}] in local repository."
    exit 1
fi

function all_ipv6_addr()
{
    ipv6_addr=$1
    one_check=`echo ${ipv6_addr} | awk -F':' '{print NF}'`
    one_check=$(( 8 - ${one_check} ))
    respace_str=:0:
    until [ ${one_check} -le 0 ]
    do
        respace_str="${respace_str}0:"
        one_check=$(( ${one_check} - 1 ))
    done
    ipv6_addr=${ipv6_addr/"::"/${respace_str}}
    ipv6_addr=${ipv6_addr/#":"/"0:"}
    ipv6_addr=${ipv6_addr/%":"/":0"}
    ipv6_addr="16#"${ipv6_addr}
    ipv6_addr=`echo ${ipv6_addr} | sed "s/:/,16#/g"`
    ipv6_addr=`echo ${ipv6_addr} | sed "s/16#0/0/g"`
    echo ${ipv6_addr}
}

function setrabbitmq_conf()
{
    local host_name="mq${LOCAL_IP//./}"
    host_name=${host_name//:/} #IPV6
    sed -i "s/localhost/${host_name}/"    ${RABBITMQ_ENV_PATH} 2>/dev/null
    log_info "Set ${host_name} to rabbitmq-env.conf successfully."

    local host_ip=$(echo ${LOCAL_IP} | tr '.' ',')
    if [[ "$(get_info.py ip_version)" == "ipv6" ]];then
        host_ip=$(all_ipv6_addr ${host_ip})
    fi

    local line_no=`cat ${RABBITMQ_ENV_PATH} | grep -n "ERL_EPMD_ADDRESS" | awk -F ':' '{print $1}'`
    sed -i "${line_no}d"   ${RABBITMQ_ENV_PATH} >/dev/null 2>&1
    sed -i "${line_no} iexport ERL_EPMD_ADDRESS=${LOCAL_IP}"   ${RABBITMQ_ENV_PATH} >/dev/null 2>&1
    log_info "Set ERL_EPMD_ADDRESS to rabbitmq-env.conf successfully."

    local line_no=`cat ${RABBITMQ_ENV_PATH} | grep -n "RABBITMQ_NODE_IP_ADDRESS" | awk -F ':' '{print $1}'`
    sed -i "${line_no}d"   ${RABBITMQ_ENV_PATH} >/dev/null 2>&1
    sed -i "${line_no} iRABBITMQ_NODE_IP_ADDRESS=${LOCAL_IP}"   ${RABBITMQ_ENV_PATH} >/dev/null 2>&1
    log_info "Set iRABBITMQ_NODE_IP_ADDRESS to rabbitmq-env.conf successfully."

    local line_no=`cat ${RABBITMQ_CFG_PATH} | grep -n "inet_dist_use_interface" | awk -F ':' '{print $1}'`
    sed -i "${line_no}d"   ${RABBITMQ_CFG_PATH} >/dev/null 2>&1
    sed -i "${line_no} i\    {inet_dist_use_interface, {${host_ip}}},"   ${RABBITMQ_CFG_PATH} >/dev/null 2>&1
    log_info "Set inet_dist_use_interface to rabbitmq.config successfully."

    local line_no=`cat ${RABBITMQ_CFG_PATH} | grep -n "ssl_listeners," | awk -F ':' '{print $1}'`
    sed -i "${line_no}d"   ${RABBITMQ_CFG_PATH} >/dev/null 2>&1
    sed -i "${line_no} i\    {ssl_listeners, [{\"${LOCAL_IP}\",5671}]},"   ${RABBITMQ_CFG_PATH} >/dev/null 2>&1
    log_info "Set ssl_listeners to rabbitmq.config successfully."

    local host_list=""
    for node in ${CLUSTER_IP_LIST[@]};do
        local node_name="mq${node//./}"
        node_name=${node_name//:/} #IPV6
        if [ -z "${host_list}" ];then
            host_list="[rabbit@${node_name}]"
        else
            host_list="${host_list%']'}, rabbit@${node_name}]"
        fi
    done

    local line_no=`cat ${RABBITMQ_CFG_PATH} | grep -n "cluster_nodes" | awk -F ':' '{print $1}'`
    sed -i "${line_no}d"  ${RABBITMQ_CFG_PATH} >/dev/null 2>&1
    sed -i "${line_no} i\    {cluster_nodes, {${host_list}, disc}},"   ${RABBITMQ_CFG_PATH} >/dev/null 2>&1
    log_info "Set cluster name and cluster ip in file rabbitmq.config."
    return 0
}

function docker_build()
{
    log_info "Execute docker build"
    docker build --force-rm=true -t ${SERV_IMG_NAME}:${SERV_IMG_VERSION} ${CURRENT_PATH}/images
}

function make_image()
{
    log_info "Begin to execute docker build..."
    /usr/bin/cp -f ${LINE_ROOT}/repo/third_party/{erlang-*.rpm,rabbitmq-server-*.tar.xz} ${CURRENT_PATH}/images/installfiles
    CHECK_RESULT $? "Can not find erlang and rabbitmq-server package."
    replace_variable BASE_IMG_VERSION ${LINE_ROOT}/services/rabbitmq/images/Dockerfile
    /usr/bin/cp -f ${LINE_ROOT}/bin/utils.sh ${LINE_ROOT}/services/rabbitmq/images/installfiles
    cmd_retry "docker_build" "3" "3"
    if [ $? -eq 0 ];then
        log_info "Execute docker build finished."
    else
        log_error "Execute rabbitmq build failed."
        exit 1
    fi
}

setrabbitmq_conf
make_image
log_info "Merge and load rabbitmq successfully."
exit 0
