#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
service_name="rabbitmq"
rabbit_tag=`cat /opt/huawei/dj/versions/rabbitmq.ver`
rabbitmq_img_name="rabbitmq:${rabbit_tag}"

if [ -f /usr/bin/rabbitmqControl ];then
    rabbitmqControl -S STOP
    if [ $? -ne 0 ];then
        log_error "rabbitmqControl is running, begin to hard to stop it."
        exit 1
    fi
fi
log_info "stop rabbitmq successfully."


function stop_and_remove_container()
{
    inst_num=`docker ps -a |grep ${service_name} |wc -l`
    if [ ${inst_num} -lt 1 ];then
        log_info "There is no container instance ${service_name}, skip."
        return 0
    fi
    docker rm -f ${service_name} >/dev/null 2>&1
    if [ "$?" != "0" ];then
        log_error "delete the ${service_name} container failed"
        return 1
    fi
    return 0
}

function remove_image()
{
    for i in `seq 5`;do
        image=`docker images -a -q ${rabbitmq_img_name}`
        if [ "$?" == "0" ] && [ -z "${image}" ];then
            log_info "${image} image do not exist, skip to delete."
            return 0
        fi

        docker rmi -f ${image} >/dev/null 2>&1
        if [ $? -ne 0 ];then
            log_info "remove rabbitmq images failed,try times:${i}."
            sleep 1
            continue
        else
            log_info "remove rabbitmq images successfully!"
            return 0
        fi
    done
    return 1
}

function remove_files()
{
    rm -f /etc/rsyslog.d/rsyslog_rabbitmq.conf
    rm -f /opt/huawei/dj/inspect/sh/rabbitmq.sh
    rm -rf /opt/huawei/dj/tools/services/rabbitmq/
    rm -rf /opt/huawei/dj/etc/rabbitmq/
    rm -rf /usr/bin/rabbitmqControl
    return 0
}

stop_and_remove_container
if [ $? -ne 0 ];then
    log_error "stop_and_remove_container failed."
    exit 1
fi

remove_image
if [ $? -ne 0 ];then
    log_error "uninstall_image failed."
    exit 1
fi

remove_files
log_info "uninstall rabbitmq successfully."
exit 0
