#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/rabbitmq_upgrade.log"

function rollback_files()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]];then
        log_error "Failed to rollback files."
        return 1
    fi
    log_info "Success to rollback files."
    return 0
}

function rollback_rabbitmq_container()
{
    # rollback container
    cmd_retry "/usr/bin/rabbitmqControl -S STOP" 120 5 >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Stop rabbitmq failed."
        return 1
    fi
    log_info "Stop rabbitmq success."
    cmd_retry "docker rm -f rabbitmq" 10 5 >/dev/null 2>&1
    check_container=`docker ps -a | grep rabbitmq | wc -l`
    if [[ ${check_container} -ne 0 ]];then
        log_error "Remove container failed."
        return 1
    fi
    log_info "Remove container success."
    new_version=$(read_microservice_ver ${LINE_ROOT}/services/rabbitmq/rabbitmq.ver)
    remove_image "rabbitmq:${new_version}"; CHECK_RESULT $?
    rollback_files; CHECK_RESULT $?
    rollback_image ${CURRENT_DIR}/backup_files/ "rabbitmq"
    if [[ $? -ne 0 ]];then
        log_error "Error to rollback rabbitmq image."
        return 1
    fi
    log_info "Rollback rabbitmq image success."
    cmd_retry "/usr/bin/rabbitmqControl -S RUN" 120 5 >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Start rabbitmq failed."
        return 1
    fi
    log_info "Start rabbitmq success."
    return 0
}

rollback_rabbitmq_container; CHECK_RESULT $?
sed -i '/^rabbitmq$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback rabbitmq success."
exit 0
