#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LOG_TAG="resource_manager_start"
source ${CURRENT_PATH}/utils.sh
CONF_FILE="/etc/resource_manager/resource_manager.conf"
CONF_JSON="${CURRENT_PATH}/config.json"

####################################################################
#TODO:以下方法暂时放在当前目录，karbor安装整改后统一放到basesdk并生成入口
csbs_python ${CURRENT_PATH}/sync_config.py "${CONF_FILE}" "${CONF_JSON}"
####################################################################
CHECK_RESULT $? "Sync config failed."

csbs_python ${CURRENT_PATH}/resource_manage_watcher.py sync
CHECK_RESULT $? "Sync watch config failed."

resource_manager-manage --config-file=${CONF_FILE} db_sync
CHECK_RESULT $? "Sync database failed."

while true;do
    cms_component_num=`pgrep -f ${CURRENT_PATH}/resource_manage_watcher.py`
    if [[ -z "${cms_component_num}" ]];then
        log_warn "Resource_manage_watcher stopped, try to restart."
        proc_manager --start ${CURRENT_PATH}/resource_manage_watcher.py
    fi
    resource_managerControl -CS CompontState
    if [[ $? -ne 0 ]];then
        log_warn "Resource_manager-api stopped, try to restart."
        resource_managerControl -A RESTART
    fi
    sleep 10
done