#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
SERV_IMG_VERSION=`read_microservice_ver ${LINE_ROOT}/services/resource_manager/resource_manager.ver`
BASE_IMG_VERSION=`read_microservice_ver ${LINE_ROOT}/services/base/base.ver`

log_info "Begin to merge and load resource_manager."
img_nums=`docker images -q resource_manager:${SERV_IMG_VERSION} | wc -l`
if [[ ${img_nums} -gt 0 ]];then
    log_error "Found same version image [resource_manager:${SERV_IMG_VERSION}] in local repository."
    exit 1
fi

function docker_build()
{
    log_info "Execute docker build"
    docker build --force-rm=true -t resource_manager:${SERV_IMG_VERSION} ${CURRENT_PATH}/dockerbuild
    return $?
}

/usr/bin/cp -f ${LINE_ROOT}/repo/self_developed/resource_manager-*.whl ${CURRENT_PATH}/dockerbuild/installfiles
CHECK_RESULT $? "Can not find resource_manager package."
log_info "Begin to execute docker build..."
replace_variable BASE_IMG_VERSION "${LINE_ROOT}/services/resource_manager/dockerbuild/Dockerfile"
cmd_retry "docker_build" "3" "3"
img_nums=`docker images -q resource_manager:${SERV_IMG_VERSION} | wc -l`
if [[ ${img_nums} -eq 0 ]];then
    log_error "Build image [resource_manager:${SERV_IMG_VERSION}] failed."
    exit 1
fi
log_info "Merge and load resource_manager successfully."
