#!/bin/bash
if [ ${UID} -ne 0 ];then
    sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
source /opt/huawei/dj/inst/bin/utils.sh
####################################################################
#TODO:以下日志输出和工具方法暂时放在脚本中,日志输出整改时替换到公共utils中
function LOG ()
{
    logger -id -p local1.$1 -t ${LOG_TAG} "$(basename $0):$2 ${@:4}"
    [[ "$3" -ne 0 ]] && echo "[$1] ${@:4}"
}
shopt -s expand_aliases
alias log_error='LOG error ${LINENO} 0'
alias log_info='LOG info ${LINENO} 0'
alias log_warn='LOG warn ${LINENO} 0'
alias log_debug='LOG debug ${LINENO} 0'
alias echo_error='LOG error ${LINENO} 1'
alias echo_info='LOG info ${LINENO} 1'
alias echo_warn='LOG warn ${LINENO} 1'
alias echo_debug='LOG debug ${LINENO} 1'
####################################################################
LOG_TAG="resource_manager_start"
SERV_IMG_VERSION=$(read_microservice_ver /opt/huawei/dj/versions/resource_manager.ver)
HOST_IP=$(get_info.py manage_ip)
FORCE=0


function showhelp()
{
    usage="Usage: resource_managerControl"
    len=${#usage}
    echo "Usage: ${prog} [-S RUN]"
    printf "%-${len}s [-S STOP]\n"
    printf "%-${len}s [-F STOP]\n"
    printf "%-${len}s [-A RESTART]\n"
    printf "%-${len}s [-F RESTART]\n"
    printf "%-${len}s [-CS CompontState]\n"
    printf "%-${len}s [-h]\n"
    exit 1
}


function start_container()
{
    local retry=0
    while [[ ${retry} -lt 3 ]]
    do
        echo_info "Start container for resource_manager."
        docker start resource_manager > /dev/null 2>&1
        if [[ $? -eq 0 ]];then
            echo_info "Start resource_manager container successfully."
            return 0
        fi
        log_warn "Start resource_manager container failed, retry."
        retry=$(( ${retry} + 1 ))
    done
    echo_error "Start resource_manager container failed."
    exit 1
}


function run_component()
{
    docker run -d  --cpu-shares 1024  --security-opt=no-new-privileges --ipc=host \
    -v /usr/bin/get_info.py:/usr/bin/get_info.py:ro \
    -v /opt/huawei/dj/cfg:/opt/huawei/dj/cfg:ro \
    -v /opt/huawei/dj/DJSecurity:/opt/huawei/dj/DJSecurity \
    -v /etc/localtime:/etc/localtime:ro \
    -v /etc/hosts:/etc/hosts:ro \
    -v /opt/huawei/dj/paas:/opt/huawei/dj/paas \
    -v /var/log/huawei/dj/services/system/kmc:/var/log/huawei/dj/services/system/kmc \
    -v /opt/fusionplatform/data/openstack:/opt/fusionplatform/data/openstack \
    -v /opt/huawei/dj/bin/resource_manager:/opt/huawei/dj/bin/resource_manager \
    -p ${HOST_IP}:28899:28899 --memory 4000m --pids-limit 1024 --net=host --ulimit nofile=2048:2048\
    --name resource_manager -e "HOST_IP=${HOST_IP}" resource_manager:${SERV_IMG_VERSION} sh /installfiles/run.sh >/dev/null 2>&1
    if [[ $? -eq 0 ]];then
        echo_info "Run docker for resource_manager successfully."
        return 0
    fi
    echo_error "Run docker for resource_manager failed."
    exit 1
}

function component_run()
{
    echo_info "Run resource_manager begin"
    container_num=`docker ps | grep resource_manager | wc -l`
    if [[ ${container_num} -ne 0 ]];then
        echo_info "resource_manager is running."
        return 0
    fi
    container_num=`docker ps -a | grep resource_manager | wc -l`
    if [[ ${container_num} -eq 0 ]];then
        run_component
    else
        start_container
    fi
    heartBeat START resource_manager
    if [[ $? -ne 0 ]];then
        echo_error "Register heartbeat of resource_manager failed."
    else
        echo_info "Register heartbeat of resource_manager success."
    fi
    haproxy_regist add --frontend-name karbor --plane internal  --backend-name resource_manager  \
    --backend-param mode=http --backend-param balance=roundrobin --backend-param option=tcpka \
    --backend-param stats=hide-version --backend-param option=httpchk --backend-param option=httplog \
    --backend-param "acl=hdr(X-MicroVersion) -i 1.2" --frontend-port 8799 --server-ip ${HOST_IP} --server-port 28899
    if [[ $? != 0 ]];then
        echo_error "Haproxy register ${HOST_IP}:28899 of resource_manager failed."
    else
        echo_info "Haproxy register ${HOST_IP}:28899 of resource_manager success."
    fi
    echo_info "Start resource_manager successfully"
}


function remove_container()
{
    container_num=`docker ps -a | grep resource_manager | wc -l`
    if [[ ${container_num} -eq 0 ]];then
        echo_info "Container for resource_manager not exist and can not remove"
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 3 ]]
    do
        echo_info "Remove container for resource_manager."
        docker rm -f resource_manager > /dev/null 2>&1
        if [[ $? -eq 0 ]];then
            echo_info "Remove resource_manager container successfully."
            return 0
        fi
        log_warn "Remove resource_manager container failed, retry."
        retry=$(( ${retry} + 1 ))
    done
    echo_error "Remove resource_manager container failed."
    exit 1
}

function stop_container()
{
    container_num=`docker ps | grep resource_manager | wc -l`
    if [[ ${container_num} -eq 0 ]];then
        echo_info "Container for resource_manager not running and can not stop"
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 3 ]]
    do
        echo_info "Stop container for resource_manager."
        docker stop resource_manager > /dev/null 2>&1
        if [[ $? -eq 0 ]];then
            echo_info "Stop resource_manager container successfully."
            return 0
        fi
        log_warn "Stop resource_manager container failed, retry."
        retry=$(( ${retry} + 1 ))
    done
    echo_error "Stop resource_manager container failed."
    exit 1
}

function component_stop()
{
    log_info "Stop resource_manager endbegin"
    haproxy_regist delete --plane internal --frontend-name karbor --frontend-port 8799 --backend-name resource_manager --server-ip ${HOST_IP} --server-port 28899
    if [[ $? != 0 ]];then
        echo_error "Haproxy unregister ${HOST_IP}:28899 of resource_manager failed."
    else
        echo_info "Haproxy unregister ${HOST_IP}:28899 of resource_manager success."
    fi
    heartBeat STOP "resource_manager"
    if [[ $? != 0 ]];then
        echo_error "Stop heartbeat for resource_manager failed."
    else
        echo_info "Stop heartbeat for resource_manager success."
    fi
    if [[ "${FORCE}" -eq 1 ]];then
        remove_container
    else
        stop_container
    fi
    echo_info "Stop resource_manager successfully."
}


function component_restart()
{
    echo_info "resource_manager restart begin."
    component_stop
    component_run
    echo_info "resource_manager restart end."
}


function component_statusget()
{
    echo_info "Check resource_manager status begin"
    container_num=`docker ps | grep resource_manager | wc -l`
    if [[ "${container_num}" -eq  0 ]];then
        echo_error "Resource_manager container is not running."
        return 1
    fi
    docker exec resource_manager resource_managerControl -CS CompontState
    return $?
}


function args_err()
{
    echo -e "${prog}: illegal option"
    showhelp
}

log_info "INFO | #################begin exec resource_managerControl########################."
case "$1 '$2' $#" in
    "-S 'RUN' 2")
        Action=$2
        ;;
    "-S 'STOP' 2")
        Action=$2
        ;;
    "-F 'STOP' 2")
        FORCE=1
        Action=$2
        ;;
    "-A 'RESTART' 2")
        Action=$2
        ;;
    "-F 'RESTART' 2")
        FORCE=1
        Action=$2
        ;;
    "-CS 'CompontState' 2")
        Action=$2
        ;;
    "-h '' 1")
        showhelp
        ;;
    *)
        args_err
        break
        ;;
esac

if [[ "RESTART" == "${Action}" ]]; then
    (
        flock -n 211
        [[ $? -eq 1 ]] && { echo "resource_managerControl is already running";exit 1;}
        component_restart
    )211<>/tmp/resource_managerControl.lock
elif [[ "RUN" == "${Action}" ]]; then
    (
        flock -n 211
        [[ $? -eq 1 ]] && { echo "resource_managerControl is already running";exit 1;}
        component_run
    )211<>/tmp/resource_managerControl.lock
elif [[ "STOP" == "${Action}" ]]; then
    (
        flock -n 211
        [[ $? -eq 1 ]] && { echo "resource_managerControl is already running";exit 1;}
        component_stop
    )211<>/tmp/resource_managerControl.lock
elif [[ "CompontState" == "${Action}" ]]; then
    component_statusget
    exit $?
fi