#!/usr/bin/env bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/resource_manager_upgrade.log"

function rollback_backupfile()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]];then
        log_error "Failed to rollback files."
        return 1
    fi
    log_info "Success to rollback files."
    return 0
}

function remove_container()
{
    cmd_retry "docker rm -f $1" 10 5 >/dev/null 2>&1
    check_container=`docker ps -a | grep $1 | wc -l`
    if [[ ${check_container} -ne 0 ]];then
        log_error "Remove $1 container failed."
        exit 1
    fi
}

function rollback_resource_manager_container()
{
    resource_managerControl -S STOP >> ${LOG_FILE} 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Stop resource_manager failed."
        return 1
    fi
    log_info "stop resource_manager success."
    remove_container "resource_manager"
    log_info "remove container success."
    new_version=$(read_microservice_ver ${LINE_ROOT}/services/resource_manager/resource_manager.ver)
    remove_image "resource_manager:${new_version}"; CHECK_RESULT $?
    rollback_backupfile; CHECK_RESULT $?
    if [ ! -f ${CURRENT_DIR}/backup_files/resource_manager_old_image.tar.gz ];then
        rm -rf /opt/huawei/dj/versions/resource_manager.ver
        return 0
    fi
    rollback_image ${CURRENT_DIR}/backup_files/ "resource_manager"
    if [[ $? -ne 0 ]];then
        log_error "Error to rollback resource_manager image."
        return 1
    fi
    log_info "Rollback resource_manager image success."
    resource_managerControl -S RUN >> ${LOG_FILE} 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Start resource_manager failed."
        return 1
    fi
    log_info "Start resource_manager success."
    return 0
}

rollback_resource_manager_container
sed -i '/^resource_manager/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback resource_manager success."
exit 0