#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

source /opt/huawei/dj/inst/bin/utils.sh
SCAGENT_LOG_PATH="/var/log/huawei/dj/services/system/scagent"
LOG_FILE="${SCAGENT_LOG_PATH}/scagentControl.log"
ServiceState=
component=scagent

function usage()
{
    echo "Usage: $component -S ServiceState"
    echo "       $component -h for help."
    exit 1
}

function showhelp()
{
    echo "Usage: $component : -S ServiceState"
    echo "  -S ServiceState (RUN STOP)"
    echo "  -A RESTART"
    echo "  -CS CompontState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "${component}: illegal option"
    showhelp
    exit 1
}

function heartbeat_start()
{
    log_debug "start scagent heartbeat"
    heartBeat START scagent
}

function heartbeat_stop()
{
    log_debug "stop scagent heartbeat"
    heartBeat STOP scagent
}

function component_run()
{
    log_info "${component}Control: ======component_run begin"
    queryCmd=$(pgrep -f /usr/bin/scagent$)
    if [ "${queryCmd}" ]; then
        log_info "${component} process is running, skip."
        return 0
    fi
    proc_manager --start /usr/bin/scagent
    if [ $? -ne 0 ];then
        log_error "fail to start ${component}"
        exit 1
    fi
    sleep 3
    queryCmd=$(pgrep -f /usr/bin/scagent$)
    if [ -z "${queryCmd}" ]; then
        log_error "${component} process not is running, err."
        exit 1
    fi
    heartbeat_start
    log_info "${component}Control: ======component_run end"
    echo "start ${component} successfully"
}

function component_stop()
{
    log_info "${component}Control: ======component_stop begin"
    heartbeat_stop
    queryCmd=$(pgrep -f /usr/bin/scagent$)
    if [ -z "${queryCmd}" ]; then
        log_info "${component} process is not running, skip."
        return 0
    fi
    local nIdx=0
    local retry_times=10
    while [ ${nIdx} -lt ${retry_times} ]
    do
        kill -9 ${queryCmd}
        sleep 1
        queryCmd=$(pgrep -f /usr/bin/scagent$)
        if [ -z "${queryCmd}" ]; then
            break
        fi
        nIdx=$((${nIdx}+1))
    done
    if [ ${nIdx} -ge ${retry_times} ];then
        log_info "${component}Control: ======component_stop failed"
        return 1
    fi
    log_info "${component}Control: ======component_stop end"
}

function component_restart()
{
    log_debug "${component}Control: ======component_restart begin"
    component_stop
    sleep 1
    component_run
    log_debug "${component}Control: ======component_end end"
}

function component_status()
{
    pgrep -f /usr/bin/scagent$
    if [ $? -eq 0 ];then
        echo "${component} is running"
        exit 0
    else
        echo "${component} is not running"
        exit 1
    fi
}

function chown_chmod_log_dir()
{
    mkdir -p ${SCAGENT_LOG_PATH} >/dev/null 2>&1
    chown -h openstack:openstack  ${SCAGENT_LOG_PATH} >/dev/null 2>&1
    chmod 750 ${SCAGENT_LOG_PATH} >/dev/null 2>&1
}

log_info "INFO | #################begin exec scagentControl########################."
chown_chmod_log_dir
while true; do
    case "$1" in
        -S) ServiceState=$2;shift 2;;
        -CS) CompStatus=$2;shift 2;;
        -A) Action=$2;shift 2;;
        -h) showhelp $0;;
        *) shift; break;;
    esac
done

if [ "RESTART" = "${Action}" ]; then
    component_restart
elif [ "RUN" = "${ServiceState}" ]; then
    component_run
elif [ "STOP" = "${ServiceState}" ]; then
    component_stop
elif [ "CompontState" = "${CompStatus}" ]; then
    component_status
else
    args_err
fi
exit 0
