#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

if [ $# -lt 2 ]; then
    exit 1
fi

SSH_OPT="-o StrictHostKeyChecking=no -o ConnectTimeout=5"
CUR_OPER=$1
USER_NAME=$2
read -s pwd
export ENCRYPT_DATA=${pwd}
USER_NEWPWD=$(csbs_python -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))")


if [[ ${CUR_OPER} != "check" &&  ${CUR_OPER} != "modify" && ${CUR_OPER} != "reset" ]];then
   exit 15
fi
if [[ ${USER_NAME} != "djmanager" &&  ${USER_NAME} != "root" ]];then
   exit 16
fi


function check_djmanager_pwd()
{
    local passwd=$1
    local host_ip=$(get_info.py manage_ip)
    passwd=${passwd//'$'/'\$'}
    /usr/bin/expect<<-EOF
set timeout 5
spawn ssh ${SSH_OPT} djmanager@${host_ip}
expect {
        "Account temporarily locked" {exit 2}
        "expired" {exit 3}
        "password:" {send "${passwd}\r"}
       }
expect {
        "djmanager@karbor" {exit 0}
       }
exit 1
EOF
}


function check_root_pwd()
{
    local passwd=$1
    passwd=${passwd//'$'/'\$'}
    /usr/bin/expect<<-EOF
set timeout 5
spawn su djmanager
expect {
        "djmanager@karbor" {send "su\r"}
        "root@karbor" {exit 1}
       }
expect {
        "Account temporarily locked" {exit 2}
        "expired" {exit 3}
        "Password:" {send "${passwd}\r"}
       }
expect {
        "root@karbor" {exit 0}
       }
exit 1
EOF
}


function check_usr_pwd()
{
    LK=$(passwd -S ${USER_NAME} | awk '{print $2}')
    if [[ ${LK} == "LK" ]];then
        exit 13
    fi
    USER_PWD=$1
    if [[ ${USER_NAME} == "djmanager" ]];then
        check_djmanager_pwd ${USER_PWD}
    elif [[ ${USER_NAME} == "root" ]];then
        check_root_pwd ${USER_PWD}
    fi
    ret=$?
    if [ ${ret} -eq 2 ];then
        exit 13
    elif [ ${ret} -eq 3 ];then
        exit 14
    elif [ ${ret} -ne 0 ];then
        exit 12
    fi
}


if [ ${CUR_OPER} == "check" ];then
    check_usr_pwd ${USER_NEWPWD}
    exit 0
fi
if [ ${CUR_OPER} == "modify" ];then
    read -s old_pwd
    export ENCRYPT_DATA=${old_pwd}
    USER_OLDPWD=$(csbs_python -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))")
    check_usr_pwd ${USER_OLDPWD}
fi


/usr/bin/expect<<-EOF
set timeout 10
spawn passwd ${USER_NAME}
expect {
        "New password:" {send "${USER_NEWPWD}\r"}
       }
expect {
        "BAD PASSWORD: The password contains less than 3 character classes" {exit 24}
        "BAD PASSWORD: The password is shorter than 8 characters" {exit 23}
        "BAD PASSWORD: The password fails the dictionary check" {exit 22}
        "Retype new password:" {send "${USER_NEWPWD}\r"}
       }
expect {
        "Password has been already used. Choose another." {exit 21}
        "passwd: Have exhausted maximum number of retries for service" {exit 20}
        "passwd: all authentication tokens updated successfully" {exit 0}
       }
exit 1
EOF
