#!/bin/bash

CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
COMPONENT=scagent


stop()
{
    pgrep -f /usr/bin/scagent
    if [ $? -ne 0 ];then
        log_info "${COMPONENT} is not running"
        return 0
    fi
    ${COMPONENT}Control -S STOP
    if [ $? -ne 0 ];then
        log_error "fail to stop ${COMPONENT}"
        exit 1
    fi
    log_info "success to ${COMPONENT} ${COMPONENT}."
}


uninstall()
{
    rpm -q ${COMPONENT}-*.noarch
    if [ $? -ne 0 ];then
        log_info "${COMPONENT} not be installed or has been uninstalled"
        return 0;
    fi
    rpm -e ${COMPONENT}-*.noarch --nodeps
    if [ $? -ne 0 ];then
        log_error "fail to uninstall ${COMPONENT}"
        exit 1
    fi
    rm -f /usr/bin/${COMPONENT}Control
}

function main()
{
    log_info "begin to uninstall ${COMPONENT}..."
    stop
    uninstall
    log_info "uninstall ${COMPONENT} finished."
}

main
