#!/bin/bash
INSTALL_DIR=/usr/local/bin/zookeeper

function _modify_maxClientCnxns()
{
    sed -i '/maxClientCnxns/ d ' "$1"
    echo "maxClientCnxns=300" >> "$1"
}

function _modify_limit()
{
    sed -i '/initLimit/ d ' "$1"
    echo "initLimit=20" >> "$1"
    sed -i '/syncLimit/ d ' "$1"
    echo "syncLimit=10" >> "$1"
    sed -i '/tickTime/ d ' "$1"
    echo "tickTime=4000" >> "$1"
}

function _modify_autopurge()
{
    sed -i '/autopurge.snapRetainCount/ d ' "$1"
    sed -i '/autopurge.purgeInterval/ d ' "$1"
    echo "autopurge.snapRetainCount=10" >> "$1"
    echo "autopurge.purgeInterval=1" >> "$1"
}

function _modify_dataLogDir()
{
    sed -i '/dataLogDir/ d ' "$1"
    echo "dataLogDir=$2" >> "$1"
}

function _modify_JMXDISABLE()
{
    local zkServer_sh_path="${INSTALL_DIR}/zookeeper/bin/zkServer.sh"
    sed -i '/"x$JMXDISABLE"/ i JMXDISABLE=true' "${zkServer_sh_path}"
    # disable jettty
    local orgin_text="\"-Dzookeeper.root.logger=\${ZOO_LOG4J_PROP}\""
    local new_text="\"-Dzookeeper.root.logger=\${ZOO_LOG4J_PROP}\" \"-Dzookeeper.admin.enableServer=false\""
    sed -i "s/${orgin_text}/${new_text}/g" "${zkServer_sh_path}"
}

function modify_zoo_cfg()
{
    local conf_dir=${INSTALL_DIR}/zookeeper/conf
    local zoo_cfg_location=${conf_dir}/zoo.cfg
    local data_dir=${INSTALL_DIR}/zookeeper/data
    local log_dir=/var/log/huawei/dj/zookeeper
    mkdir -p ${data_dir} ${log_dir}
    mv ${conf_dir}/zoo_sample.cfg ${zoo_cfg_location} -f
    sed -i "25a ZOO_LOG_DIR=${log_dir}" ${INSTALL_DIR}/zookeeper/bin/zkEnv.sh
    sed -i "26a JAVA_HOME=/opt/huawei/dj/bin/jre" ${INSTALL_DIR}/zookeeper/bin/zkEnv.sh
    sed -i "/dataDir=/ c dataDir=${data_dir}"  ${zoo_cfg_location}
    
    # 更改ZKserver中的日志定向规则
    zk_path_bin="/usr/local/bin/zookeeper/zookeeper/bin"
    sed -i "s/zookeeper.out/zookeeper.log/" ${zk_path_bin}/zkServer.sh
    sed -i "s/>\ \"\$_ZOO_DAEMON_OUT\"/>>\ \"\$_ZOO_DAEMON_OUT\"/" ${zk_path_bin}/zkServer.sh

    # 更改maxClientCnxns，autopurge，dataLogDir
    _modify_limit ${zoo_cfg_location}
    _modify_maxClientCnxns ${zoo_cfg_location}
    _modify_autopurge ${zoo_cfg_location}
    _modify_dataLogDir ${zoo_cfg_location} ${log_dir}
    _modify_JMXDISABLE
}

function install()
{
    local install_file_name=./installfiles/apache-zookeeper*.tar.gz
    if [[ ! -d ${INSTALL_DIR} ]]; then
        mkdir -p ${INSTALL_DIR}
    fi
    tar zxvf ${install_file_name} -C ${INSTALL_DIR} >/dev/null 2>&1
    if [[ $? -ne 0 ]]; then
        echo "install zookeeper failed,quit."
        exit 1
    fi
    mv ${INSTALL_DIR}/apache-zookeeper-* ${INSTALL_DIR}/zookeeper
    mv /installfiles/sysctl.conf /etc/sysctl.conf -f
    mv /installfiles/checkState.sh ${INSTALL_DIR}/zookeeper/bin/checkState.sh -f
    mv /installfiles/dj.properties ${INSTALL_DIR}/zookeeper/conf/dj.properties -f
    mv /installfiles/*.jar ${INSTALL_DIR}/zookeeper/lib/ -f
    mv /installfiles/log4j.properties ${INSTALL_DIR}/zookeeper/conf/ -f
    mv /installfiles/java.env ${INSTALL_DIR}/zookeeper/conf/
    return 0
}

function set_chown_chmod()
{
    chown -h root:openstack $1
    if [ -d $1 ] || [ -x $1 ];then
        chmod 750 $1
    else
        chmod 640 $1
    fi
}

function setprivilege()
{
    for file in $(find $(realpath $1) -group root);do
        set_chown_chmod ${file}
    done
    for file in $(find $(realpath $1) -nogroup);do
        set_chown_chmod ${file}
    done
    for file in $(find $(realpath $1) -nouser);do
        set_chown_chmod ${file}
    done
}

function main()
{
    install
    modify_zoo_cfg
    rm /installfiles -rf
    rm -rf ${INSTALL_DIR}/zookeeper/src
    rm -rf ${INSTALL_DIR}/zookeeper/docs
    rm -rf ${INSTALL_DIR}/zookeeper/contrib
    rm -rf ${INSTALL_DIR}/zookeeper/recipes
    rm -rf ${INSTALL_DIR}/zookeeper/dist-maven
    rm -rf ${INSTALL_DIR}/zookeeper/zookeeper-*.jar.asc
    rm -rf ${INSTALL_DIR}/zookeeper/zookeeper-*.jar.md5
    rm -rf ${INSTALL_DIR}/zookeeper/zookeeper-*.jar.sha1
    rm -rf ${INSTALL_DIR}/zookeeper/README_packaging.txt
    setprivilege ${INSTALL_DIR}
    setprivilege /var/log
    setprivilege /opt/huawei
    chmod 770 /var/log/huawei/dj/zookeeper
    chmod 770 ${INSTALL_DIR}/zookeeper/{data,conf}
    chmod 660 ${INSTALL_DIR}/zookeeper/conf/{zoo.cfg,dj.properties}
    chmod 550 ${INSTALL_DIR}/zookeeper/bin/*.sh
    chmod 550 ${INSTALL_DIR}/zookeeper/bin/*.cmd
}

main
echo "install zookeeper success."
exit 0
