#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
SERV_IMG_NAME="zookeeper"
SERV_IMG_VERSION=`read_microservice_ver ${LINE_ROOT}/services/zookeeper/zookeeper.ver`
BASE_IMG_VERSION=`read_microservice_ver ${LINE_ROOT}/services/base/base.ver`


img_nums=`docker images -q ${SERV_IMG_NAME}:${SERV_IMG_VERSION} | wc -l`
if [ ${img_nums} -gt 0 ];then
    log_error "Found same version image [${SERV_IMG_NAME}:${SERV_IMG_VERSION}] in local repository."
    exit 1
fi

log_info "Execute docker build"
function docker_build()
{
    docker build --force-rm=true -t ${SERV_IMG_NAME}:${SERV_IMG_VERSION} ${CURRENT_PATH}/dockerbuild
}

function make_image()
{
    log_info "Begin to execute docker build..."
    CHECK_RESULT ${img_nums} "Found same version image [zookeeper:${SERV_IMG_VERSION}] in local repository."
    /usr/bin/cp -f ${LINE_ROOT}/repo/third_party/{apache-zookeeper-*.tar.gz,commons-codec-*.jar} ${CURRENT_PATH}/dockerbuild/installfiles
    CHECK_RESULT $? "Can not find zookeeper and commons-codec package."
    /usr/bin/cp -f ${LINE_ROOT}/repo/self_developed/zookeeper-auth.jar ${CURRENT_PATH}/dockerbuild/installfiles
    CHECK_RESULT $? "Can not find zookeeper-auth.jar package."
    replace_variable BASE_IMG_VERSION ${LINE_ROOT}/services/zookeeper/dockerbuild/Dockerfile
    cmd_retry "docker_build" "3" "3"
    if [ $? -eq 0 ];then
        log_info "Execute docker build finished."
    else
        log_error "Execute zookeeper build failed."
        exit 1
    fi
}

make_image
log_info "Merge and load zookeeper successfully."
exit 0
