#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/zookeeper_upgrade.log"

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]]; then
        log_error "backup zookeeper files failed."
        return 1
    fi
    log_info "backup zookeeper files success."
    backup_image ${CURRENT_DIR}/backup_files "zookeeper"
    if [[ $? -ne 0 ]];then
        log_error "Error to save zookeeper image."
        return 1
    fi
    log_info "save zookeeper image success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write zookeeper
    if [[ $? -ne 0 ]];then
        log_error "failed to write zookeeper upgrade flag."
        return 1
    fi
    log_info "success to write zookeeper upgrade flag."
    return 0
}

function _enable_empty_snap_trust()
{
    local origin_text="zookeeper.snapshot.trust.empty=false"
    local new_text="zookeeper.snapshot.trust.empty=true"
    sed -i "s/${origin_text}/${new_text}/g" ${CURRENT_DIR}/../dockerbuild/installfiles/java.env
}

function _disable_empty_snap_trust()
{
    local origin_text="zookeeper.snapshot.trust.empty=true"
    local new_text="zookeeper.snapshot.trust.empty=false"
    echo "sed -i \"s/${origin_text}/${new_text}/g\" /usr/local/bin/zookeeper/zookeeper/conf/java.env"
}

function _get_zk_container_id()
{
    local img_ver=$(read_microservice_ver /opt/huawei/dj/versions/zookeeper.ver)
    local zk_img="zookeeper:${img_ver}"
    local container_id=$(docker ps -q -f name=zookeeper)
    if [[ ! -n "$container_id" ]] ;then
        log_error "ZooKeeper container_id is null."
        exit 1
    else
        echo ${container_id}
    fi
}

function install_new()
{
    cmd_retry "zookeeperControl -S STOP" 120 5 >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "stop zookeeper failed."
        return 1
    fi
    log_info "stop zookeeper success."
    cmd_retry "docker rm -f zookeeper" 10 5 >/dev/null 2>&1
    check_container=`docker ps -a | grep zookeeper | wc -l`
    if [[ ${check_container} -ne 0 ]];then
        log_error "remove container failed."
        return 1
    fi
    log_info "remove container success."
    _enable_empty_snap_trust;CHECK_RESULT $? "Enable zk snap empty trust failed."
    sh ${CURRENT_DIR}/../uninstall.sh
    sh ${CURRENT_DIR}/../merge.sh
    sh ${CURRENT_DIR}/../install.sh
    sh ${CURRENT_DIR}/../start.sh
    sh ${CURRENT_DIR}/../post_start.sh
    return 0
}

function upgrade()
{
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    install_new; CHECK_RESULT $?

    docker exec -u root $(_get_zk_container_id) bash -c "$(_disable_empty_snap_trust)"
    CHECK_RESULT $? "Disable zk snap empty trust failed."
}

upgrade;ret_val=$?
exit ${ret_val}