#ifndef SC_CERTSIGNAPI_H
#define SC_CERTSIGNAPI_H

#include "sc_type.h"
#include "sc_csctype.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef SC_OS_WINDOW
#define SC_DLL_EXPORT  __declspec(dllexport) 
#else
#define SC_DLL_EXPORT
#endif

SC_DLL_EXPORT int CSC_Initialize(char *cscCfgFile);
SC_DLL_EXPORT int CSC_Finalize();
SC_DLL_EXPORT int CSC_GenPrivateKey(char *passwd, EncryptAlgID pwdEncAlgID, KeyAlgID keyAlgId, CSCKeyPair *keyPair);
SC_DLL_EXPORT int CSC_GenPrivateKeyNoPwd(KeyAlgID keyAlgId, CSCKeyPair *keyPair);
SC_DLL_EXPORT int CSC_GenCertReq(CSCCertInfo certInfo, CSCSignCallBackOp *signCallBack, CSCCertData *csrResult);
SC_DLL_EXPORT int CSC_GenSerialNo(char **serialNo);
SC_DLL_EXPORT int CSC_GenRootCACert(CSCCertInfo certInfo, CSCSignCallBackOp *signCallBack, CSCCertData *caResult);
SC_DLL_EXPORT int
CSC_SignCertReq(CSCCSRInfo csrInfo, CSCKeyPair caKeyInfo, CSCSignCallBackOp *signCallBack, CSCCertData *certResult);
SC_DLL_EXPORT int
CSC_SignData(CSCKeyPair caKeyInfo, unsigned char *signData, int dataLen, unsigned char **signResult, int *resultLen);
SC_DLL_EXPORT int
CSC_GenCrl(CSCCrlSignInfo signinfo, CSCKeyPair caKeyInfo, CSCSignCallBackOp *signCallBack, CSCCertData *crlResult);
SC_DLL_EXPORT int
CSC_ResetPrivateKeyPwd(CSCKeyPair keyInfo, char *passout, const EncryptAlgID pwdEncAlgID, CSCKeyPair *keyPair);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif //SC_CERTSIGNAPI_H