#!/bin/bash
update_param="{{local_restore}}"
count=`echo ${update_param} | awk -F ';' '{print NF}'`
until [ ${count} -le 0 ]
do
    value=`echo ${update_param} | awk -F';' '{print  $(echo "'"${count}"'")}'`
    count=$(( ${count} - 1 ))
    format_check=`echo ${value} | awk -F ':' '{print NF}'`
    if [ ${format_check} -ne 2 ];then
        echo "${value} format is error, skip !"
        continue
    fi
    az_name=`echo ${value} | awk -F ':' '{print $1}'`
    restore_az=`echo ${value} | awk -F ':' '{print $2}' | sed "s: ::g"`
    restore_az="['"${restore_az//,/"'","'"}"']"
    update_az=`set_az_backup_cp --op list | awk -F '|' '{print $2}' | sed "s: ::g" | grep "^${az_name}\$"`
    if [ -z "${update_az}" ];then
        echo "${az_name} backup unsupported, skip !"
        continue
    fi
    set_az_backup_cp --op update --name ${update_az} --local_restore_targets "${restore_az}" --remote_restore_targets "${restore_az}"
done