#!/bin/bash
export PATH=$PATH:/usr/sbin
LOG_FILE=/var/log/huawei/dj/services/system/upgradeagent/cps-monitor_upgrade.log
MAX_RETRY_TIME=10
WAIT_TIME=10

function LOG()
{
    local dir=${0}
    local dir=$(basename $(dirname ${dir}))/$(basename ${dir})
    echo "$(date "+%Y-%m-%d %H:%M:%S") [$1] ${dir}: $2 ${@:3}" >> ${LOG_FILE}
}

shopt -s expand_aliases
alias log_error='LOG ERROR $LINENO'
alias log_info='LOG INFO $LINENO'
alias log_warn='LOG WARN $LINENO'
alias log_debug='LOG DEBUG $LINENO'

check_cps_monitor()
{
    line=`ps -ef|grep "cps_monitor"|grep -v "grep"|wc -l`
    if [[ ${line} -eq 0 ]];then
        return 1
    fi
    return 0
}

stop_cps_monitor()
{
    for (( times=1; times<=$MAX_RETRY_TIME; times++ ));do
        kill -9 $(pgrep -f sys_monitor) >/dev/null 2>&1
        kill -9 $(pgrep -f cps_monitor) >/dev/null 2>&1
        sleep ${WAIT_TIME}
        check_cps_monitor
        if [[ $? -ne 0 ]];then
            log_info "Stop cps-monitor service success."
            return 0
        fi
    done
    log_error "Stop cps-monitor service failed."
    exit 1
}

start_cps_monitor()
{
    for (( times=1; times<=$MAX_RETRY_TIME; times++ ));do
        /usr/bin/start_service --s cps-monitor --n $1
        sleep ${WAIT_TIME}
        check_cps_monitor
        if [[ $? -eq 0 ]];then
            log_info "Start cps-monitor service success."
            return 0
        fi
    done
    log_error "Start cps-monitor service failed."
    exit 1
}

main()
{
    cur_host=`/usr/bin/get_info.py hostname`
    if [[ -z "$cur_host" ]];then
        log_error "Get hostname failed"
        exit 1
    fi
    op_type="${1}"
    case "${op_type}" in
        restart)
            stop_cps_monitor  ${cur_host}
            start_cps_monitor ${cur_host}
            ;;
        stop)
            stop_cps_monitor  ${cur_host}
            ;;
        *)
            log_info "Unsupported operation type ${op_type}"
            ;;
    esac
}

main "${1}"
exit 0