# -*- coding:utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCUException
import utils.common.log as logger
from plugins.eBackup.common.util import ebackup_cipher_precheck
from plugins.eBackup.common.util import Utils


class DatamoverPrecheck(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(DatamoverPrecheck, self).__init__(project_id, pod_id,
                                                regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.param_dict = Utils.init_system_params(project_id,
                                                   regionid_list[0])

    def execute(self, project_id, pod_id, regionid_list=None):
        try:

            server_ips = self.param_dict['eBackup_Datamover_nodes']
            server_ips = server_ips.replace(" ", "").replace("|", ";"). \
                split(";")
            ret = ebackup_cipher_precheck(server_ips,
                                          self.param_dict['eBackup_hcp_pwd'],
                                          self.param_dict['eBackup_root_pwd'],
                                          self.param_dict['update_scene'],
                                          self.param_dict['eBackup_Version'])
            return ret

        except FCUException as e:
            logger.error("Precheck failed: " + str(e))
            return Message(500, e)

        except Exception as e:
            logger.error("Failed to exec precheck ,the reason is %s" % e)
            return Message(500, error_msg_cn="加密算法切换前检查出现异常，"
                                             "请查看日志并重试，"
                                             "异常信息:%s" % str(e),
                           error_msg_en="Exception occurs while prechecking,"
                                        "please check the log and try again, "
                                        "error info:%s." % str(e))

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        return self.execute(project_id, pod_id, regionid_list)


class WorkflowPrecheck(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(WorkflowPrecheck, self).__init__(project_id, pod_id,
                                               regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.param_dict = Utils.init_system_params(project_id,
                                                   regionid_list[0])

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            server_ips = self.param_dict['eBackup_Workflow_nodes']
            server_ips = server_ips.replace(" ", "").replace("|", ";"). \
                split(";")
            ret = ebackup_cipher_precheck(server_ips,
                                          self.param_dict['eBackup_hcp_pwd'],
                                          self.param_dict['eBackup_root_pwd'],
                                          self.param_dict['update_scene'],
                                          self.param_dict['eBackup_Version'])
            return ret
        except FCUException as e:
            logger.error("Precheck failed: " + str(e))
            return Message(500, e)

        except Exception as e:
            logger.error("Failed to exec precheck ,the reason is %s" % e)
            return Message(500, error_msg_cn="加密算法切换前检查出现异常，"
                                             "请查看日志并重试，"
                                             "异常信息:%s" % str(e),
                           error_msg_en="Exception occurs while prechecking,"
                                        "please check the log and try again, "
                                        "error info:%s." % str(e))

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        return self.execute(project_id, pod_id, regionid_list)
