# -*- coding:utf-8 -*-
import os
import base64
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
import utils.common.log as logger
from utils.common.exception import FCUException
from utils.DBAdapter.DBConnector import BaseOps
from plugins.eBackup.common.eBackupDriverUpgrade import EbackupDriverUpgrader
from utils.common.ssh_util import Ssh
from plugins.eBackup.common.util import update_driver_cert_path
from plugins.eBackup.common.util import Utils


class DriverUpgrade(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(DriverUpgrade, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region_id = regionid_list[0]
        self.database = BaseOps()
        self.__db_param_dict = Utils.init_system_params(project_id,
                                                        regionid_list[0])
        self.__ssh = Ssh()

    def _execute_upgrade(self, reverse_proxy_ip):
        try:
            driver_upgrade = EbackupDriverUpgrader(reverse_proxy_ip,
                                                   self.__db_param_dict)
            upgrade_result = driver_upgrade.upgrade()
            update_driver_cert_path(reverse_proxy_ip, self.__db_param_dict)
            return upgrade_result
        except Exception as ex:
            logger.error(str(ex))
            return False

    def check_cutover_status(self):
        ssh_client = None
        try:
            file_path = os.path.realpath(
                __file__ + '/../bin/queryDriverNodes.py')
            fsp_user = "fsp"
            fsp_pwd = self.__db_param_dict['openstack_fsp_pwd']
            fsp_root_pwd = self.__db_param_dict['openstack_root_pwd']
            cps_admin_pwd_unicode = self.__db_param_dict[
                'openstack_cps_admin_pwd']
            cps_admin_pwd = base64.b64encode(
                cps_admin_pwd_unicode.encode("utf-8")).decode(encoding="utf-8")
            reverse_proxy_ip = self.__db_param_dict[
                'openstack_reverse_proxy_ip']
            ssh = Ssh()
            ret = ssh.put_file(reverse_proxy_ip, fsp_user,
                               fsp_pwd, file_path, "/home/fsp/")
            if not ret:
                logger.error("Upload %s to %s failed." % (file_path,
                                                          reverse_proxy_ip))
                raise FCUException(650007, reverse_proxy_ip, '/home/fsp',
                                   fsp_user)
            logger.info("Upload queryDriverNode.py to %s successfully." %
                        reverse_proxy_ip)

            cmd = 'cd /home/fsp;chmod +x queryDriverNodes.py;' + \
                  'python queryDriverNodes.py cps_admin \"%s\" ' + \
                  'check_cutover && echo "Success";' % cps_admin_pwd + \
                  '''sed -i '/queryDriverNodes.py/ d' ~/.bash_history;''' + \
                  '''history -c;rm -f /home/fsp/queryDriverNodes.py'''
            ssh_client = ssh.ssh_create_client(reverse_proxy_ip, fsp_user,
                                               fsp_pwd)
            ssh.ssh_send_command(ssh_client, 'su - root', 'Password:', 100)
            ssh.ssh_send_command(ssh_client, fsp_root_pwd, '#', 100)
            result = ssh.ssh_exec_command_return_list(ssh_client, cmd)
            if -1 == str(result).find("Success"):
                logger.error("Cinder backup deploy info cutover is"
                             " not completed.")
                return False
            logger.error("Cinder backup deploy info cutover is completed.")
            return True
        except Exception as e:
            logger.error(
                "Check cinder backup cutover status failed: " + str(e))
            raise e
        finally:
            Utils.close_ssh_clinet(ssh_client)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            reverse_proxy_ip = self.__db_param_dict[
                'openstack_reverse_proxy_ip']
            is_true = self._execute_upgrade(reverse_proxy_ip)
            if not is_true:
                logger.info("Fail to Upgrade eBackup driver.")
                return Message(500, "Fail to Upgrade eBackup driver.")
            return Message(200)
        except FCUException as ex:
            logger.error("Exception occurs when upgrade "
                         "eBackup driver: " + str(ex))
            return Message(500, ex)
        except Exception as e:
            logger.error("Upgrade eBackup driver failed, "
                         "the reason is: " + str(e))
            return Message(500, error_msg_cn="升级eBackup Driver失败，"
                                             "请查看日志详情, 异常信息：%s" %
                                             str(e),
                           error_msg_en="Upgrade eBackup driver failed,please"
                                        " see the log for detail, error info："
                                        "%s" % str(e))

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        return self.execute(project_id, pod_id, regionid_list)
