# --*-- coding: utf-8 --*--

import utils.common.log as logger

from plugins.CSDR_CSHA_VHA.common.AutoRetry import retry
from plugins.CSDR_CSHA_VHA.common.CSDRTestBase import SCTenantApi
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_service_type
from plugins.CSDR_CSHA_VHA.common.Validater import judge_test_step_result
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eReplication")


class CleanResource(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        super(CleanResource, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.region_id = regionid_list[0]
        self.service_type = get_service_type(self.project_id)

    def pre_check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行安装前的参数预检查和获取

        该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """

        return Message(200)

    @retry(3, 20, 20, (FCUException, Exception),
           validate=judge_test_step_result)
    def execute(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行测试

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """

        try:
            logger.info("Clean DR resource tenant start.")
            sc_tool = SCTenantApi(
                self.project_id, self.pod_id, self.region_id,
                self.service_type)
            sc_tool.clean_resource()
            logger.info("Clean DR resource tenant success.")
            return Message(200)
        except FCUException as e:
            logger.error(
                f"Clean DR resource tenant failed, err_msg={str(e)}.")
            return Message(500, e)
        except Exception as e:
            logger.error(
                f"Clean DR resource tenant failed, err_msg={str(e)}.")
            return Message(
                500, f"清理资源租户失败[{str(e)}]",
                f"Failed to clean DR resource tenant[{str(e)}]",
                "请检查", "Please check.")

    def rollback(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行回滚

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """

        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :return: Message类对象
        """

        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """

        return Message(200)
