# -*- coding:utf-8 -*-

import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.AutoRetry import retry
from plugins.CSDR_CSHA_VHA.common.DataMigrateBase import CorrectingDataBase
from plugins.CSDR_CSHA_VHA.common.Validater import judge_upgrade_step_result
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eReplication")


class CorrectingUnifyPassword(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        super(CorrectingUnifyPassword, self).__init__(
            project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]

    def pre_check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)

    @retry(3, 20, 20, (FCUException, Exception),
           validate=judge_upgrade_step_result)
    def execute(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """

        try:
            logger.info("Start correcting unify password data progress.")
            correcting_data_tool = CorrectingDataBase(
                self.project_id, self.pod_id, self.regionid_list)
            correcting_data_tool.correcting_unify_password()
            logger.info("Correcting unify password data progress finish.")
            return Message(200)
        except FCUException as fe:
            logger.error(
                f"Correcting unify password data failed, "
                f"err_msg={str(fe)}.")
            return Message(500, fe)
        except Exception as e:
            logger.error(
                f"Correcting unify password data failed, "
                f"err_msg={str(e)}.")
            return Message(500, FCUException('665002', str(e)))

    def rollback(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行回滚

        :return: Message对象
        """

        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :return:
        """

        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行注册，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)
