# -*- coding:utf-8 -*-
import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.AutoRetry import retry
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_service_type, \
    create_dmk_user, get_server_migrate_params
from plugins.CSDR_CSHA_VHA.common.ServerProcessor import DMKParamsTool
from plugins.CSDR_CSHA_VHA.common.Validater import judge_check_step_result
from utils.business.dmk_util import DmkApi
from utils.common.check_result import CheckResult
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eReplication")


class InitDmkUser(StepBaseInterface):
    """初始化DMK账户"""

    def __init__(self, project_id, pod_id, regionid_list):
        super(InitDmkUser, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_type = get_service_type(self.project_id)
        server_migrate_params = get_server_migrate_params(
            self.project_id, self.region, self.service_type)
        self.source_dmk_float_ip = server_migrate_params.get(
            "source_dmk_float_ip")
        self.source_dmk_admin_user = server_migrate_params.get(
            "source_dmk_admin_user")
        self.source_dmk_admin_user_pwd = server_migrate_params.get(
            "source_dmk_admin_user_pwd")
        self.source_server_business_pwd = \
            server_migrate_params.get("source_server_business_pwd")
        self.source_server_root_pwd = \
            server_migrate_params.get("source_server_root_pwd")
        self.target_dmk_float_ip = server_migrate_params.get(
            "target_dmk_float_ip")
        self.target_dmk_admin_user = server_migrate_params.get(
            "target_dmk_admin_user")
        self.target_dmk_admin_user_pwd = server_migrate_params.get(
            "target_dmk_admin_user_pwd")
        self.target_server_business_pwd = \
            server_migrate_params.get("target_server_business_pwd")
        self.target_server_root_pwd = \
            server_migrate_params.get("target_server_root_pwd")
        source_dmk_info_dict = \
            {"dmk_float_ip": self.source_dmk_float_ip,
             "dmk_sys_user": self.source_dmk_admin_user,
             "dmk_sys_user_pwd": self.source_dmk_admin_user_pwd,
             "vm_server_ssh_pwd": self.source_server_business_pwd,
             "vm_server_ssh_sudo_pwd": self.source_server_root_pwd}
        target_dmk_info_dict = \
            {"dmk_float_ip": self.target_dmk_float_ip,
             "dmk_sys_user": self.target_dmk_admin_user,
             "dmk_sys_user_pwd": self.target_dmk_admin_user_pwd,
             "vm_server_ssh_pwd": self.target_server_business_pwd,
             "vm_server_ssh_sudo_pwd": self.target_server_root_pwd}
        self.source_dmk_params_ins = DMKParamsTool(
            self.project_id, self.regionid_list,
            dmk_info_dict=source_dmk_info_dict)
        self.target_dmk_params_ins = DMKParamsTool(
            self.project_id, self.regionid_list,
            dmk_info_dict=target_dmk_info_dict)

    def pre_check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，

        工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """

        __msg__ = dict()
        if not self.source_dmk_params_ins.check_dmk_ip_connection():
            logger.error(
                f"Ping {self.source_dmk_params_ins.dmk_float_ip} failed.")
            __msg__.update(
                {"DMK Address": self.source_dmk_params_ins.dmk_float_ip})
        if not self.target_dmk_params_ins.check_dmk_ip_connection():
            logger.error(
                f"Ping {self.target_dmk_params_ins.dmk_float_ip} failed.")
            __msg__.update(
                {"DMK Address": self.target_dmk_params_ins.dmk_float_ip})
        if len(__msg__):
            logger.error(f"Check host connected failed, {__msg__}.")
            raise FCUException('665001', __msg__)

    @retry(3, 20, 20, (FCUException, Exception),
           validate=judge_check_step_result)
    def execute(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行安装前预检查&安装&配置

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """

        results = list()
        try:
            logger.info("Start init dmk user.")
            __dmkObj__ = DmkApi()
            # 检查环境连通性
            self.pre_check(self.project_id, self.pod_id, regionid_list)

            create_dmk_user(__dmkObj__, self.source_dmk_params_ins)
            create_dmk_user(__dmkObj__, self.target_dmk_params_ins)
            check = CheckResult(
                itemname_ch="迁移前初始化DMK帐户",
                itemname_en="Initialize Dmk Account Before Migrate",
                status="success", error_msg_cn="")
            results.append(check)
            return Message(200, check_results=results)
        except FCUException as e1:
            logger.error(f"Init dmk failed, err_msg={str(e1)}.")
            check = CheckResult(
                itemname_ch="迁移前初始化DMK帐户",
                itemname_en="Initialize Dmk Account Before Migrate",
                status="failure", error_msg_cn=e1)
            results.append(check)
            return Message(200, check_results=results)
        except Exception as e:
            logger.error(f"Init dmk failed, err_msg={str(e)}.")
            check = CheckResult(
                itemname_ch="迁移前初始化DMK帐户",
                itemname_en="Initialize Dmk Account Before Migrate",
                status="failure", error_msg_cn=FCUException(
                    665002, str(e)))
            results.append(check)
            return Message(200, check_results=results)

    def rollback(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行回滚

        :param project_id:
        :param pod_id:
        :return:Message类对象
        """

        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :return: Message类对象
        """

        logger.info("Start retry init dmk user")
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :param project_id:
        :param pod_id:
        :return:
        """

        return Message(200)
