# --*-- coding: utf-8 --*--
import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.CommonUtil import check_system_pwd
from plugins.CSDR_CSHA_VHA.common.CommonUtil import check_value_null
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_all_server_nodes
from utils.business.param_util import HandleParamCheck
from utils.business.param_util import ParamUtil
from utils.common.code2Msg import code2Msg


class ParamsCheck(object):

    def __init__(self, project_id, service_type):
        self.project_id = project_id
        self.service_type = service_type
        self.component_name = service_type.upper()
        self.db_opt = ParamUtil()
        self.need_check_data = \
            self.db_opt.get_need_check_cloud_params(
                self.project_id, self.component_name)
        self.basic_checked_keys = list()
        self.os_users_check_lst = list()
        self.check_result = HandleParamCheck()
        self.server_business_key = "eReplication_server_node_ssh_password"
        self.server_root_key = "eReplication_server_node_ssh_sudo_password"
        self.check_key_list = [self.server_business_key, self.server_root_key]
        self.server_ip1 = ""

    def basic_check(self):
        for key, value in self.need_check_data.items():
            if check_value_null(value):
                logger.error(f"The value is None: {key}.")
                self.check_result.set_check_result(
                    param_keys=[key], status=500, error_msg=code2Msg(665005))
            else:
                self.basic_checked_keys.append(key)

    def get_server_ip01_from_db(self):
        vm_info = ParamUtil().get_vm_info_by_vm_name(
            self.project_id, "Service-eReplication01")
        if not vm_info:
            # 数据割接场景可能出现从6.5.1使用8.0.X-8.0.3升级路径进行升级的场景，需要兼容虚拟机名称为Service-eReplication
            vm_info = ParamUtil().get_vm_info_by_vm_name(
                self.project_id, "Service-eReplication")
            if not vm_info:
                logger.info("Service VM is not existed.")
                self.check_result.set_check_result(
                    param_keys=self.check_key_list,
                    status=500, error_msg=code2Msg(675011))
                return
        self.server_ip1 = vm_info[0].get('ip')

    def check_server_ip_login_and_user_expire(self, host=None):
        self.get_server_ip01_from_db()
        if self.server_ip1:
            host = host if host else self.server_ip1
            login, check = check_system_pwd(
                host, "DRManager", self.server_business_key,
                self.server_root_key, self.check_result,
                self.need_check_data, self.basic_checked_keys)
            return login, check
        return False, False

    def check_all_server_ip_login_and_user_expire(self):
        login1, check1 = self.check_server_ip_login_and_user_expire()
        self.os_users_check_lst.append(check1)
        if not login1:
            logger.error(
                f"Login server failed, host: {self.server_ip1}.")
            return self.check_result
        all_ips = get_all_server_nodes(
            self.server_ip1, "DRManager",
            self.need_check_data.get(self.server_business_key),
            self.need_check_data.get(self.server_root_key))
        if len(all_ips) not in [2, 4] or self.server_ip1 not in all_ips:
            logger.error(
                f"Query eReplication ip from {self.server_ip1} failed.")
            self.check_result.set_check_result(
                param_keys=self.check_key_list, status=500,
                error_msg=code2Msg(665006))
            return self.check_result
        all_ips.remove(self.server_ip1)
        if not all_ips:
            return self.check_result

        for ip in all_ips:
            login2, check2 = self.check_server_ip_login_and_user_expire(ip)
            self.os_users_check_lst.append(check2)

        if False not in self.os_users_check_lst:
            self.check_result.set_check_result(
                param_keys=self.check_key_list, status=200, error_msg="")

        if len(self.check_result.check_list) == 0:
            self.check_result.set_check_result(
                param_keys=self.check_key_list, status=200, error_msg='')
        return self.check_result
