# -*- coding:utf-8 -*-

import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.AutoRetry import retry
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_server_params
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_service_type
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_version_info
from plugins.CSDR_CSHA_VHA.common.Validater import judge_upgrade_step_result
from utils.business.project_util import ProjectApi
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eReplication")


class SaveVersion(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        super(SaveVersion, self).__init__(
            project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_type = get_service_type(self.project_id)

        server_params = get_server_params(
            self.project_id, self.region, self.service_type)
        self.server_ip1 = server_params["server_ip1"]
        self.server_business_user = server_params["server_business_user"]
        self.server_business_user_pwd = server_params[
            "server_business_user_pwd"]
        self.server_root_pwd = server_params["server_root_pwd"]

    def pre_check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)

    @retry(3, 20, 20, (FCUException, Exception),
           validate=judge_upgrade_step_result)
    def execute(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """

        try:
            logger.info("Start save component version.")
            if not self.server_ip1:
                logger.error("Get server ip failed.")
                raise FCUException("665008")

            # 获取Server升级前后版本号
            info = get_version_info(
                self.server_ip1, self.server_business_user,
                self.server_business_user_pwd, self.server_root_pwd,
                project_id)
            project = ProjectApi()
            project.save_version_info(project_id, self.service_type, info)
            logger.info("Save component version successfully.")
        except FCUException as fe:
            logger.error(
                f"Save component version failed, err_msg={str(fe)}.")
            return Message(500, fe)
        except Exception as e:
            logger.error(
                f"Save component version failed, err_msg={str(e)}.")
            return Message(500, FCUException('665002', str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行回滚

        :return: Message对象
        """

        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :return:
        """

        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行注册，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)
