# -*- coding:utf-8 -*-

import utils.common.log as logger
from utils.common.message import Message

RESULT_CODE = {"ERROR": 500, "SUCCESS": 200}
RESULT_STATUS = {"SUCCESS": "success", "FAILURE": "failure"}


def judge_check_step_result(check_result):
    if isinstance(check_result, Message):
        results = check_result.check_results
        for result in results:
            if result.status == RESULT_STATUS.get("FAILURE"):
                logger.error(
                    f"Execute step failed, error "
                    f"message: {result.description_en}.")
                return False
        return True
    else:
        return False


def judge_upgrade_step_result(upgrade_result):
    if isinstance(upgrade_result, Message):
        if upgrade_result.status_code == RESULT_CODE.get("SUCCESS"):
            return True
        else:
            logger.error(
                f"Execute step failed, error "
                f"message: {upgrade_result.error_msg_en}.")
            return False
    else:
        return False


def judge_test_step_result(test_result):
    if isinstance(test_result, Message):
        if test_result.status_code == RESULT_CODE.get("SUCCESS"):
            return True
        else:
            logger.error(
                f"Execute step failed, error "
                f"message: {test_result.error_msg_en}.")
            return False
    else:
        return False


def judge_submit_step_result(submit_result):
    if isinstance(submit_result, Message):
        if submit_result.status_code == RESULT_CODE.get("SUCCESS"):
            return True
        else:
            logger.error(
                f"Execute step failed, error "
                f"message: {submit_result.error_msg_en}.")
            return False
    else:
        return False


def judge_rollback_step_result(rollback_result):
    if isinstance(rollback_result, Message):
        if rollback_result.status_code == RESULT_CODE.get("SUCCESS"):
            return True
        else:
            logger.error(
                f"Execute step failed, error "
                f"message: {rollback_result.error_msg_en}.")
            return False
    else:
        return False
