# coding: UTF-8


def check_param(dev_obj):
    if not dev_obj or not isinstance(dev_obj, dict):
        return False
    ssh = dev_obj.get("SSH")
    if not hasattr(ssh, "execCmd"):
        return False
    return True


def execute(dev_obj):
    if not check_param(dev_obj):
        return False, ""
    try:
        ssh = dev_obj.get("SSH")
        tmp = dev_obj.get("devIp")
        ssh.execCmd("rm -f /tmp/DataCollect_{}.tar".format(tmp))
        return True, ""
    except Exception:
        return False, ""
