# coding: UTF-8
import re

G_STRCMD = "/opt/huawei/dj/inspect/DJCollect.sh"

# 信息收集项的编号定义，比如2.1项定义为G_ITEM_21=21
G_BEFORE_COLLECT = "00"
G_ITEM_10 = "10"
G_ITEM_11 = "11"

G_ITEM_20 = "20"
G_ITEM_21 = "21"
G_ITEM_23 = "23"
G_ITEM_24 = "24"
G_ITEM_25 = "25"
G_ITEM_26 = "26"
G_ITEM_27 = "27"
G_ITEM_28 = "28"
G_ITEM_29 = "29"
G_ITEM_210 = "210"
G_ITEM_211 = "211"
G_ITEM_212 = "212"
G_ITEM_213 = "213"
G_ITEM_214 = "214"
G_ITEM_215 = "215"
G_ITEM_216 = "216"
G_ITEM_218 = "218"

G_ITEM_30 = "30"
G_ITEM_31 = "31"
G_ITEM_32 = "32"
G_FINISH_COLLECT = "finish"


def check_int_str(value):
    if not value and not isinstance(value, str):
        return False
    not_num_re = '^[0-9a-z]*$'
    re_com = re.compile(not_num_re)
    if not re_com.match(value):
        return False
    return True


def check_param(dev_obj, num):
    if not dev_obj or not isinstance(dev_obj, dict):
        return False
    ssh = dev_obj.get("SSH")
    if not hasattr(ssh, "execCmd") or not check_int_str(num):
        return False
    return True


def execute(dev_obj, num):
    if not check_param(dev_obj, num):
        dev_obj.get("logger").info(num)
        dev_obj.get("logger").info("check_param failed.")
        return False, ""
    try:
        ssh = dev_obj.get("SSH")
        dev_ip = dev_obj.get("devIp")
        ret_str_cmd = "bash {} {} {}".format(G_STRCMD, num, dev_ip)
        str_ret = str(ssh.execCmd(ret_str_cmd))
        if str_ret is None or str_ret.find("ERROR:") != -1:
            return False, ""
        if num == G_FINISH_COLLECT:
            ssh.execCmd("chmod 444 /tmp/DataCollect_{}.tar".format(dev_ip))
        return True, ""
    except Exception:
        return False, ""


def execute_prepare(dev_obj):
    return execute(dev_obj, G_BEFORE_COLLECT)


def execute_10(dev_obj):
    return execute(dev_obj, G_ITEM_10)


def execute_11(dev_obj):
    return execute(dev_obj, G_ITEM_11)


def execute_20(dev_obj):
    return execute(dev_obj, G_ITEM_20)


def execute_21(dev_obj):
    return execute(dev_obj, G_ITEM_21)


def execute_23(dev_obj):
    return execute(dev_obj, G_ITEM_23)


def execute_24(dev_obj):
    return execute(dev_obj, G_ITEM_24)


def execute_25(dev_obj):
    return execute(dev_obj, G_ITEM_25)


def execute_26(dev_obj):
    return execute(dev_obj, G_ITEM_26)


def execute_27(dev_obj):
    return execute(dev_obj, G_ITEM_27)


def execute_28(dev_obj):
    return execute(dev_obj, G_ITEM_28)


def execute_29(dev_obj):
    return execute(dev_obj, G_ITEM_29)


def execute_210(dev_obj):
    return execute(dev_obj, G_ITEM_210)


def execute_211(dev_obj):
    return execute(dev_obj, G_ITEM_211)


def execute_212(dev_obj):
    return execute(dev_obj, G_ITEM_212)


def execute_213(dev_obj):
    return execute(dev_obj, G_ITEM_213)


def execute_214(dev_obj):
    return execute(dev_obj, G_ITEM_214)


def execute_215(dev_obj):
    return execute(dev_obj, G_ITEM_215)


def execute_216(dev_obj):
    return execute(dev_obj, G_ITEM_216)


def execute_218(dev_obj):
    return execute(dev_obj, G_ITEM_218)


def execute_30(dev_obj):
    return execute(dev_obj, G_ITEM_30)


def execute_31(dev_obj):
    return execute(dev_obj, G_ITEM_31)


def execute_32(dev_obj):
    return execute(dev_obj, G_ITEM_32)


def execute_finish(dev_obj):
    return execute(dev_obj, G_FINISH_COLLECT)
