# -*- coding:utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
import utils.common.log as logger
from plugins.eBackup.common.util import Utils
from plugins.eBackup.common.util import get_cur_cipher_status
from plugins.eBackup.common.eBackup_cipher_change import EbackupCipherChanger


class DatamoverRollback(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(DatamoverRollback, self).__init__(project_id, pod_id,
                                                regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.cur_cipher_status = get_cur_cipher_status()
        self.__db_param_dict = Utils.init_system_params(project_id, regionid_list[0])

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            host_info = self.__db_param_dict["eBackup_Datamover_nodes"]
            host_info = host_info.replace(" ", "").split("|")

            for group in host_info:
                ebackup_changer = EbackupCipherChanger(
                    group, self.__db_param_dict, self.project_id,
                    region_id=self.regionid_list[0])
                ebackup_changer.do_change(self.cur_cipher_status)
            return Message(200)

        except Exception as ex:
            logger.error(str(ex))
            return Message(500,
                           error_msg_cn="切换Datamover算法出现异常,"
                                        "请查看升级日志并重试，"
                                        "异常信息：%s" % str(ex),
                           error_msg_en="Exception occurs when upgrade "
                                        "Datamover,please see log and try "
                                        "again, error info:%s" % str(ex))

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        return self.execute(project_id, pod_id, regionid_list)


class WorkflowRollback(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(WorkflowRollback, self).__init__(project_id, pod_id,
                                               regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.cur_cipher_status = get_cur_cipher_status()
        self.__db_param_dict = Utils.init_system_params(project_id, regionid_list[0])

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            host_info = self.__db_param_dict["eBackup_Workflow_nodes"]
            host_info = host_info.replace(" ", "").split("|")

            for group in host_info:
                ebackup_changer = EbackupCipherChanger(
                    group, self.__db_param_dict, self.project_id,
                    region_id=self.regionid_list[0])
                ebackup_changer.do_change(self.cur_cipher_status)

            return Message(200)

        except Exception as ex:
            logger.error(str(ex))
            return Message(500,
                           error_msg_cn="Workflows算法切换出现异常,"
                                        "请查看升级日志并重试，"
                                        "异常信息：%s" % str(ex),
                           error_msg_en="Exception occurs when changing "
                                        "Datamover cipher ,please see log and"
                                        " try again, error info:%s" % str(ex))

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        return self.execute(project_id, pod_id, regionid_list)


class RollbackCMDB(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(RollbackCMDB, self).__init__(project_id, pod_id,
                                             regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.change_alg_mode = get_cur_cipher_status()
        self.__db_param_dict = Utils.init_system_params(project_id, regionid_list[0])

    def execute(self, project_id, pod_id, regionid_list=None):
        try:

            ebackup_changer = EbackupCipherChanger(
                None, self.__db_param_dict, self.project_id,
                region_id=self.regionid_list[0])
            ebackup_changer.update_cmdb_info(self.change_alg_mode)
            return Message(200)
        except Exception as ex:
            logger.error(str(ex))
            return Message(500,
                           error_msg_cn="回滚CMDB信息出现异常,"
                                        "请查看升级日志并重试，"
                                        "异常信息：%s" % str(ex),
                           error_msg_en="Exception occurs when changing "
                                        "Datamover cipher ,please see log and"
                                        " try again, error info:%s" % str(ex))

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        return self.execute(project_id, pod_id, regionid_list)
