# -*- coding:utf-8 -*-
import os
import stat
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
import utils.common.log as logger
from utils.common.exception import FCUException
from utils.DBAdapter.DBConnector import BaseOps
from plugins.eBackup.common.eBackupUpgrade import EbackupUpgrader
from plugins.eBackup.common.util import Utils
from plugins.eBackup.common.util import CommonConfig


class WorkflowUpgrade(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(WorkflowUpgrade, self).__init__(project_id,
                                              pod_id,
                                              regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.database = BaseOps()
        self.regionid_list = regionid_list
        self.__db_param_dict = Utils.init_system_params(project_id,
                                                        regionid_list[0])
        self.failed_node_key = f"Workflow_fail_node_{str(regionid_list[0])}"

    def execute(self, project_id, pod_id, regionid_list=None):
        region_type = self.database.get_region_type(self.project_id)
        logger.info("The network type is %s" % region_type)
        try:
            host_info = self.__db_param_dict["eBackup_Workflow_nodes"]
            host_info = host_info.replace(" ", "").split("|")

            all_result = []
            Utils.set_value_to_config_file(self.failed_node_key, "")
            logger.info("Begin to change FspScence config on WorkFlow node.")
            common_config = CommonConfig(
                self.__db_param_dict,
                region_id=self.regionid_list[0],
                project_id=self.project_id)
            common_config.config("FspScene")
            for group in host_info:
                host_ips = group.split(";")
                logger.info("Begin to set kms info on WorkFlow node.")
                common_config.config_kms_info(host_ips, False, sence="upgrade")
                logger.info(f"Begin to upgrade workflow nodes({str(host_ips)})")
                ebackup_upgrade = EbackupUpgrader(host_ips, self.__db_param_dict, "workflow")
                fail_reason = "DMK upgrade fail."
                try:
                    is_true = ebackup_upgrade.upgrade()
                except Exception as e:
                    fail_reason = str(e)
                    is_true = False
                if is_true:
                    logger.info("Upgrade eBackup workflow(%s) successfully." %
                                str(host_ips))
                else:
                    logger.error(f"Fail to upgrade eBackup workflow({str(host_ips)}). reason: {fail_reason}")
                    fail_node = Utils.get_value_from_config_file(self.failed_node_key)
                    if group not in fail_node:
                        if fail_node:
                            fail_node = fail_node + '|' + group
                        else:
                            fail_node = group
                    Utils.set_value_to_config_file(self.failed_node_key, fail_node)
                all_result.append(is_true)

            if False in all_result:
                logger.error("Fail to upgrade all eBackup workflow nodes.")
                return Message(500, error_msg_cn="升级Workflow失败，"
                                                 "请登录DMK查看失败原因，并重试",
                               error_msg_en="Upgrade Workflow failed, "
                                            "please log in DMK to see the "
                                            "details, and try again.")

            logger.info("Upgrade all eBackup workflow successfully.")
            Utils.set_value_to_config_file(self.failed_node_key, "")
            return Message(200)

        except Exception as ex:
            logger.error(str(ex))
            return Message(500, error_msg_cn="升级Workflow出现异常，"
                                             "请查看升级日志并重试, "
                                             "异常信息：%s" % str(ex),
                           error_msg_en="Exception occurs when upgrade "
                                        "Workflow,please see log and try "
                                        "again, errof info:%s" % str(ex))

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        try:
            host_group_list = Utils.get_value_from_config_file(self.failed_node_key)
            if host_group_list:
                host_group_list = host_group_list.split('|')

            for group in host_group_list:
                host_ips = group.split(";")
                ebackup_upgrade = EbackupUpgrader(host_ips, self.__db_param_dict, "workflow")
                is_true = ebackup_upgrade.rollback_force()
                if not is_true:
                    logger.error("Rollback %s failed." % str(group))
                    return Message(500, error_msg_cn="回退workflow[%s]失败，"
                                                     "请联系技术支持" %
                                                     str(group),
                                   error_msg_en="Rollback eBackup 回退workflow"
                                                "[%s]failed,please contact "
                                                "support engineers." %
                                                str(group))

            return self.execute(project_id, pod_id, regionid_list)
        except FCUException as ex:
            logger.error("Exception occurs when retry to "
                         "upgrade eBackup: " + str(ex))
            return Message(500, ex)
        except Exception as e:
            logger.error("Exception occurs when retry to "
                         "upgrade eBackup: " + str(e))
            return Message(500, error_msg_cn="重试出现异常，请联系技术支持， "
                                             "异常信息：%s" % str(e),
                           error_msg_en="Exception occurs when retry to "
                                        "upgrade eBackup,please contact  "
                                        "support engineers, error info：%s" %
                                        str(e))
