# -*- coding:utf-8 -*-

import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.ConsoleProcessor import \
    backup_console_service
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eReplication")


class SubmitConsoleService(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        super(SubmitConsoleService, self).__init__(
            project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list

    def pre_check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)

    def execute(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """

        try:
            logger.info("Upgrade submit console service process.")
            backup_console_service(self.pod_id, backup_type="delete")
            logger.info("Upgrade submit console service success.")
            return Message(200)
        except FCUException as fe:
            logger.error(f"Upgrade submit console failed, err_msg={str(fe)}.")
            return Message(500, fe)
        except Exception as e:
            logger.error(f"Upgrade submit console failed, err_msg={str(e)}.")
            return Message(500, FCUException('665002', str(e)))

    def rollback(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行回滚

        :return: Message对象
        """

        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :return:
        """

        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行注册，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)
