import ipaddress
import os
import socket
import ssl
import sys

from kmc import kmc

SERVER_HOSTNAME = "KarborProxy"


def check_ip(ip):
    if not isinstance(ip, (str, int)):
        return False
    try:
        ipaddress.ip_address(ip)
        return True
    except Exception:
        return False


def check_port(port):
    if not isinstance(port, int):
        return False
    return 0 <= port <= 65535


def read_file(file_path):
    with open(file_path, 'r') as f:
        return f.read().strip()


def make_ssl_context():
    return ssl.SSLContext(ssl.PROTOCOL_TLS_CLIENT)


def set_ssl_context(ssl_context, ca, cert, key, pwd):
    ssl_context.options |= ssl.OP_NO_TLSv1
    ssl_context.options |= ssl.OP_NO_TLSv1_1
    ssl_context.load_cert_chain(cert, key, pwd)
    ssl_context.load_verify_locations(ca)
    return ssl_context


def make_sock():
    return socket.socket(socket.AF_INET, socket.SOCK_STREAM)


def make_ssl_sock(ssl_context, sock):
    return ssl_context.wrap_socket(sock, server_hostname=SERVER_HOSTNAME)


def test_connectivity():
    try:
        pwd = kmc.API().decrypt(0, read_file(kmc_kegen_path))
        context = set_ssl_context(make_ssl_context(), ca, cert, key, pwd)
        socket.setdefaulttimeout(10)
        sock = make_sock()
        ssl_sock = make_ssl_sock(context, sock)
        ssl_sock.connect((str(haproxy_ip), int(haproxy_port)))
    except Exception as e:
        print(f"Test connection failure:\n  {e}.")


if __name__ == '__main__':
    install_path = sys.argv[1]
    haproxy_ip = sys.argv[2]
    haproxy_port = int(sys.argv[3])
    if all([len(sys.argv) == 4, os.path.exists(install_path), check_ip(haproxy_ip), check_port(haproxy_port)]):
        ca = os.path.join(install_path, 'AgentAssist/conf/cert/ca.pem')
        cert = os.path.join(install_path, 'AgentAssist/conf/cert/ca-cert.pem')
        key = os.path.join(install_path, 'AgentAssist/conf/cert/ca-key.pem')
        kmc_kegen_path = os.path.join(install_path, 'AgentAssist/conf/kmc_kegen')
        test_connectivity()
