@echo off
echo off
setlocal EnableDelayedExpansion
rem -----------------------------------------------
rem this shell for an unified installation(window)
rem -----------------------------------------------

title AgentAssist upgrade
set INSTALL_PATH=%1
set STEPS=%2
set CURRENT_PATH=%~dp0
set PYTHON_PKG=!CURRENT_PATH!python3
set LOG_FILE="%INSTALL_PATH%PKG\upgrade.log"
set SCRIPT_RETURN=%INSTALL_PATH%PKG\output.txt
set KMC_KEYSTORE_PATH=c:\huawei\agentassist\kmc\conf

goto Start

:Log
    echo %date:~0,10% %time:~0,8% %username% "%~1" >> %LOG_FILE%
    goto :EOF

:clear_useless_packages
    call :clear_package AgentAssist_Image
    call :clear_package AgentAssistPython_Image
    call :clear_package AgentAssist_Bak
    call :clear_package AgentAssistPython_Bak
    goto :EOF

:get_install_path
    set try_count=5
    for %%i in (0, 1, 2, 3, 4) do (
        echo "Please input an installation address of the agent assistant. You have !try_count! chances."
        set /p read_install_path=
        if exist !read_install_path!\AgentAssist (
            if exist !read_install_path!\AgentAssistPython (
                set INSTALL_PATH=!read_install_path!
                call :Log "Label_get_install_path The install path is geted successfully. !INSTALL_PATH!"
                goto :EOF
            )
            echo "The agent AgentAssistPython package does not exist."
        ) else (
            echo "The agent assistant package does not exist."
        )
        set /a try_count-=1
    )
    color 0C
    echo The number of incorrect inputs reaches 5. The installation process exits.
    pause
    exit

:clear_package
    if exist %INSTALL_PATH%%1 (
        rd /s/q %INSTALL_PATH%%1 > nul
        call :Log "Label_clear_package The %1 folder is deleted successfully."
    ) else (
        call :Log "Label_clear_package The %1 folder is not exist."
    )
    goto :EOF

:finally_handle
    call :clear_useless_packages
    if exist %INSTALL_PATH%PKG\upgrade.log (
        XCOPY /y %INSTALL_PATH%PKG\upgrade.log %INSTALL_PATH%\AgentAssist\log > nul
        call :Log "Label_finally_handle The log is copied successfully."
    )
    if exist %INSTALL_PATH%PKG (
        rd /s/q %INSTALL_PATH%PKG > nul
        call :Log "Label_finally_handle The AgentAssistImage folder is deleted successfully."
    )
    goto :EOF

:upgrade_rollback
    if not defined STEPS (
        color 0C
        echo The client assistant is upgraded failed, start roll back...
    )

    call :Log "Label_upgrade_rollback Failed to upgrade the agentassist, start roll_back."
    call :stop_process
    call :clear_package AgentAssist_Image
    call :clear_package AgentAssistPython_Image
    call :roll_back AgentAssist
    call :roll_back AgentAssistPython
    call :upgrade_kmc_keystone
    call :Log "Label_upgrade_rollback The folder is roll_backed successfully."

    call %INSTALL_PATH%AgentAssist\start.bat "CALLED" > nul
    for /f "tokens=* delims=" %%i in ('wmic process where "name = 'python.exe'" get commandline ^| find /v "agentassisthandle" ^| find /v "kmc" ^| find /c "AgentAssistPython"') do set "process_num=%%~i"
    if %process_num% GEQ 3 (
        call :Log "Label_upgrade_rollback The process is started successfully."
    ) else (
        call :Log "Label_upgrade_rollback The process is started failed."
    )

    call :finally_handle
    if not defined STEPS (
        echo The client assistant is upgraded failed, please check the upgrade.log
        pause
    )
    exit

:roll_back
    if exist %INSTALL_PATH%%1_Bak (
        call :clear_package %1
        move %INSTALL_PATH%%1_Bak %INSTALL_PATH%%1 > nul
        call :Log "Label_upgrade_rollback The %1_Bak rename to %1 successfully."
    ) else (
        call :Log "Label_upgrade_rollback %INSTALL_PATH%%1_Bak not exist."
    )
    goto :EOF

:start_process
    call %INSTALL_PATH%AgentAssist\start.bat "CALLED" > nul
    call :Log "Label_start_process The errorlevel is %errorlevel%"
    for /f "tokens=* delims=" %%i in ('wmic process where "name = 'python.exe'" get commandline ^| find /v "agentassisthandle" ^| find /v "kmc" ^| find /c "AgentAssistPython"') do set "process_num=%%~i"
    call :Log "Label_start_process The process_num is %process_num%"
    if %process_num% GEQ 3 (
        call :Log "Label_start_process The process is started successfully."
        goto :EOF
    ) else (
        call :Log "Label_start_process Failed to started the process."
        goto upgrade_rollback
    )
    goto :EOF

:stop_process
    call %INSTALL_PATH%AgentAssist\stop.bat "CALLED" > nul
    call :Log "Label_stop_process The process is stopped successfully."
    goto :EOF

:rename_all_folders
    cd %INSTALL_PATH%
    call :rename_folder AgentAssist AgentAssist_Bak
    call :rename_folder AgentAssist_Image AgentAssist
    call :rename_folder AgentAssistPython AgentAssistPython_Bak
    call :rename_folder AgentAssistPython_Image AgentAssistPython
    goto :EOF

:rename_folder
    if not exist %INSTALL_PATH%%1 (
        call :Log "Label_rename_folder %INSTALL_PATH%%1 not exist."
        goto upgrade_rollback
    )
    move %INSTALL_PATH%%1 %INSTALL_PATH%%2 > nul
    if exist %INSTALL_PATH%%1 (
        call :Log "Label_rename_folder Failed to rename %1 to %2."
        goto upgrade_rollback
    )
    call :Log "Label_rename_folder Success to rename %1 to %2. "
    goto :EOF

:upgrade_kmc_keystone
    if exist %KMC_KEYSTORE_PATH%\primary_keystore.txt (
        del /f /q %KMC_KEYSTORE_PATH%\primary_keystore.txt > nul
    )
    if exist %KMC_KEYSTORE_PATH%\standby_keystore.txt (
        del /f /q %KMC_KEYSTORE_PATH%\standby_keystore.txt > nul
    )
    XCOPY /y %INSTALL_PATH%AgentAssist\conf\standby_keystore.txt %KMC_KEYSTORE_PATH% > nul
    XCOPY /y %INSTALL_PATH%AgentAssist\conf\primary_keystore.txt %KMC_KEYSTORE_PATH% > nul
    call :Log "Label_upgrade_kmc_keystone The kmc keystore file is upgraded successfully."
    goto :EOF

:upgrade_process
    call :stop_process
    call :rename_all_folders
    call :upgrade_kmc_keystone
    call :start_process
    goto :EOF

:upgrade_python
    set image_python_path=%INSTALL_PATH%AgentAssistPython_Image
    md %image_python_path%
    XCOPY /s /e /y %PYTHON_PKG% %image_python_path% > nul
    call :Log "Label_upgrade_python PYTHON_PKG = !PYTHON_PKG!, CURRENT_PATH = !CURRENT_PATH!, image_python_path = !image_python_path!."
    set old_file=!INSTALL_PATH!AgentAssistPython\Lib\site-packages\agentassist.pth
    set new_path=!image_python_path!\Lib\site-packages\
    XCOPY /y !old_file! !new_path! > nul
    call :Log "Label_upgrade_python The Python environment variable file is copied successfully "
    goto :EOF

:Start
    if "!INSTALL_PATH!" == "" (
        set LOG_FILE="!CURRENT_PATH!upgrade.log"
        set SCRIPT_RETURN=!CURRENT_PATH!output.txt
        call :get_install_path
        if "!INSTALL_PATH:~-1!" NEQ "\" (
            set INSTALL_PATH=!INSTALL_PATH!\
        )
    )

    if exist !SCRIPT_RETURN! (
        del /f /q %SCRIPT_RETURN% > nul
    )
    if "!STEPS!" NEQ "UPGRADE_PROCESS" (
        call :Log "Label_Start upgrade UPGRADE_FILE start. INSTALL_PATH = !INSTALL_PATH!, STEPS = !STEPS!. "
        call :clear_useless_packages
        %INSTALL_PATH%AgentAssistPython\python.exe %CURRENT_PATH%\scripts\upgrade.py !CURRENT_PATH! !INSTALL_PATH! > %SCRIPT_RETURN%
        for /f "delims=" %%a in (!SCRIPT_RETURN!) do (
            set return_value=%%a
        )
        if "!return_value!" neq "success" (
            call :Log "Label_Start Failed to upgrade the agent assistant."
            echo "Failed to upgrade the agent assistant."
            goto upgrade_rollback
        )
        call :Log "Label_Start The script is successfully executed."
        call :upgrade_python
        call :Log "Label_Start The python images create successfully."
    )
    if "!STEPS!" NEQ "UPGRADE_FILE" (
        call :Log "Label_Start upgrade UPGRADE_PROCESS start. INSTALL_PATH = !INSTALL_PATH!, STEPS = !STEPS!. "
        call :Log "Label_Start start restart process."
        call :upgrade_process
        call :finally_handle
        call :Log "Label_Start The client assistant is upgraded successfully."
        if not defined STEPS (
            color 0A
            echo The client assistant is upgraded successfully.
            pause
        )
    )
    exit
