#!/usr/bin/python3
import platform
import stat
from enum import Enum
from enum import IntEnum


class ArchiveType(Enum):
    ZIP = 1
    TAR = 2


class IPType(Enum):
    IPV4 = 1
    IPV6 = 2


class SystemType(Enum):
    WINDOWS = 1
    LINUX = 2


class Permission(IntEnum):
    PERMISSION_755 = stat.S_IRWXU | stat.S_IRGRP | stat.S_IXGRP | \
                     stat.S_IROTH | stat.S_IXOTH
    PERMISSION_640 = stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP
    PERMISSION_440 = stat.S_IRUSR | stat.S_IRGRP
    PERMISSION_600 = stat.S_IRUSR | stat.S_IWUSR
    PERMISSION_400 = stat.S_IRUSR
    PERMISSION_700 = stat.S_IRWXU
    PERMISSION_500 = stat.S_IRUSR | stat.S_IXUSR


class CommonDefine(object):
    SYS_TYPE = platform.system().strip().lower()
    IS_WINDOWS = (SYS_TYPE == SystemType.WINDOWS.name.lower())
    IS_LINUX = (SYS_TYPE == SystemType.LINUX.name.lower())
