#!/usr/bin/python3


import six


class AgentAssistantException(Exception):
    message = "An unknown exception occurred."
    headers = {}
    safe = True

    def __init__(self, message=None, **kwargs):
        self.kwargs = kwargs

        message = self._format_message(message, kwargs)
        self.msg = message

        super(AgentAssistantException, self).__init__(message)

    def _format_message(self, message, kwargs):
        if not message:
            try:
                message = self.message % kwargs
            except Exception:
                message = self.message
        elif isinstance(message, Exception):
            message = six.text_type(message)

        return message

    def __str__(self):
        return self.msg

    def __unicode__(self):
        return self.__str__()


class InternalError(AgentAssistantException):
    message = "Internal error."
    error_code = "CSBS.9999"


class DBUserPathError(AgentAssistantException):
    message = "The database user name or path is incorrect."
    error_code = "CSBS.7036"


class DBMissingDriver(AgentAssistantException):
    message = "Database missing driver."
    error_code = "CSBS.7037"


class DBNotInstalled(AgentAssistantException):
    message = "Database is not installed."
    error_code = "CSBS.7038"


class DirSpaceNoEnough(AgentAssistantException):
    message = "The installation directory has no enough space."
    error_code = "CSBS.7039"


class PackageSizeError(AgentAssistantException):
    message = "The Subagent installation package size is incorrect."
    error_code = "CSBS.7040"


class ClientNotSupport(AgentAssistantException):
    message = "The Subagent client does not support this system."
    error_code = "CSBS.7041"


class ErrorBackupJobIsRunning(AgentAssistantException):
    message = "Running backup jobs(eefproc, datasourceproc) have been detected, please stop them first."
    error_code = "CSBS.7042"
