#!/usr/bin/python3
import logging
import os

from concurrent_log_handler import ConcurrentRotatingFileHandler

from common.common_define import CommonDefine
from common.common_define import Permission
from common.configreader import INSTALL_PATH
from common.configreader import g_cfg_agentassist

# 助手安装/升级/卸载日志
AGENT_ASSIST_INSTALL_LOG = "AgentAssist_install.log"
# 子agent安装/升级/卸载日志
SUBAGENT_INSTALL_LOG = "subagent_install.log"
AGENT_ASSIST_MANAGER_LOG = "AgentAssist_manager.log"
# rdagent进程日志
RDAGENT_LOG = "rdagent.log"
# monitor进程日志
MONITOR_LOG = "monitor.log"


class Logger(object):

    def __init__(self):
        self.formatter_str = "[%(asctime)s][%(name)s]:[%(threadName)s]:" \
                             "[%(levelname)s], [%(filename)s]:[%(lineno)s];" \
                             "[%(funcName)s];[%(message)s]"
        self.path = os.path.join(INSTALL_PATH, 'AgentAssist/log')
        self.max_log_size = g_cfg_agentassist.get_int_option('agent_log',
                                                             'max_log_size')
        self.max_log_num = g_cfg_agentassist.get_int_option('agent_log',
                                                            'max_log_num')
        self.chmod = None if CommonDefine.IS_WINDOWS else \
            Permission.PERMISSION_600
        if not os.path.exists(self.path):
            os.makedirs(self.path, mode=0o700)

    def get_logger(self, log_name=RDAGENT_LOG, log_level=logging.INFO,
                   log_path=None):
        if log_path is None:
            filename = os.path.join(self.path, log_name)
        else:
            filename = os.path.join(log_path, log_name)
        abs_filename = os.path.realpath(filename)
        logger = logging.getLogger(abs_filename)
        logger.setLevel(log_level)
        if not logger.handlers:
            file_handler = ConcurrentRotatingFileHandler(
                filename=abs_filename,
                maxBytes=self.max_log_size,
                backupCount=self.max_log_num,
                chmod=self.chmod
            )
            _formatter = logging.Formatter(self.formatter_str)
            file_handler.setFormatter(_formatter)

            logger.addHandler(file_handler)
        return logger
