import threading


def singleton(cls, *args, **kwargs):
    instances = {}
    lock = threading.Lock()

    def _singleton():
        with lock:
            if cls not in instances:
                instances[cls] = cls(*args, **kwargs)
        return instances[cls]

    return _singleton
