from queue import Queue

from message.tcp.cdecorator import singleton


@singleton
class MessageQueue(object):
    """用于agent助手响应agentproxy请求"""

    def __init__(self):
        self._req_queue = Queue()
        self._rsp_queue = Queue()

    def push_req(self, message):
        self._req_queue.put(message)

    def pop_req(self):
        return self._req_queue.get()

    def is_req_empty(self):
        return self._req_queue.empty()

    def push_rsp(self, message):
        self._rsp_queue.put(message)

    def pop_rsp(self):
        return self._rsp_queue.get()

    def is_rsp_empty(self):
        return self._rsp_queue.empty()
