#!/bin/bash
set +x

G_HCP_MAIN_PATH=/opt/huawei-data-protection/ebackup
function get_role()
{
    echo $(grep '^MachineRole=' ${G_HCP_MAIN_PATH}/conf/hcpconf.ini | awk -F'=' '{print $2}')
}
function check_service_status()
{
    local Num=0
    local count=300
    local L_ROLE=$(get_role)
    while [ $count -gt 0 ];do
        if [[ -f "/etc/SuSE-release" ]]; then
            Num=`service hcp status 2>/dev/null | grep -v "dsware_agent" | grep -c "isn't running"`
        fi

        if [[ -f "/etc/euleros-release" ]]; then
            Num=`/usr/sbin/service hcp status 2>/dev/null | grep -v "dsware_agent" | grep -c "isn't running"`
        fi
        if [ $Num -eq 0 ]
        then
            break
        fi
        sleep 2
        ((count--))
    done

    if [ $Num -ne 0 ]
    then
        echo $Num > Service_Check_Result
        return $Num
    fi
    echo $Num > Service_Check_Result

    if [ "${L_ROLE}" == "0" -o "${L_ROLE}" == "2" ]
    then
      
        count=300
        while [ $count -gt 0 ];do
            if [[ -f "/etc/SuSE-release" ]]; then
                Gaussdb_status=`service hcp status 2>/dev/null | grep -v "dsware_agent" | grep "gaussdb is running"`
            fi

            if [[ -f "/etc/euleros-release" ]]; then
                Gaussdb_status=`/usr/sbin/service hcp status 2>/dev/null | grep -v "dsware_agent" | grep "gaussdb is running"`
            fi
            if [ -n "${Gaussdb_status}" ];then 
                return 0
            fi
            echo "[check_service_status,$LINENO]gaussdb is not running" >> Service_Check_Result
            sleep 2
            ((count--))
        done
        return 1
    fi
}


function main()
{
    check_service_status
    return $?
}

main $@
exit $?