#!/bin/sh
set +x

G_OS_TYPE="" #操作系统的类型

function output_os_type()
{
    if [ `uname -m` == "x86_64" ];then
        if [[ -f "/etc/SuSE-release" ]]; then
            G_OS_TYPE="SuSE_x86_64"
        elif [[ -f "/etc/euleros-release" ]]; then
            G_OS_TYPE="Euler_x86_64"
        fi
    elif [ `uname -m` == "aarch64" ];then
        G_OS_TYPE="Euler_arm64"
    else
        return 1
    fi
    
    echo "${G_OS_TYPE}"
    return 0
}

function main()
{
    local L_OPERATOR=$1
    case "${L_OPERATOR}" in
        get_os_type)
            output_os_type
            local L_RET=$?
            if [ $L_RET -ne 0 ];then
                exit 1
            fi
            ;;
        *)
            ###usage
            echo "Parameter error."
            exit 1
            ;;
        esac
}

main "$@"
exit $?
