#!/bin/bash
ENT_PATH="/etc/sysconfig/network-scripts/";
#to avoid mutiple default gw begin
#get current default gw
l_insert=`/usr/sbin/route -n  | grep -v "Kernel" | grep -v "Destination"| awk '$2 != "0.0.0.0"' | head -n 1 | awk '{print "any net "$1," netmask "$3," gw "$2}'`
#clean default gw in /etc/sysconfig/static-routes
sed -i '/^any[[:space:]]*net[[:space:]]*0.0.0.0[[:space:]]*netmask[[:space:]]*0.0.0.0[[:space:]]*gw[[:space:]]*/d' /etc/sysconfig/static-routes
#insert current default gw to /etc/sysconfig/static-routes
sed -i "1 i$l_insert" /etc/sysconfig/static-routes
#to avoid mutiple default gw end
ETH_LIST=`ip a|grep -vE "lo|:mgr"|grep "BROADCAST"|awk -F':' '{print $2}' ` 
for line in $ETH_LIST
do
    ETHCONFIG="$ENT_PATH/ifcfg-$line"
    if [ -f "$ETHCONFIG" ]
    then
        #SuSe or Euler2.2 vrm, exist ip and ifcfg-ethx by hand
        #To avoid of resolv.conf be changed automaticlly begin 
        if [[ `grep "PEERDNS='no'" $ETHCONFIG` = "" ]]
        then
            echo "PEERDNS='no'" >> $ETHCONFIG
        fi
   fi
done
sed -i '/^dhclient$/d' /etc/rc.local
sed -i '/^dhclient$/d' /etc/rc.d/rc.local
