#!/bin/bash
set +x

fsp_user_name="fsp"
fsp_user_group_name="fsp"
hcp_script_logfile="/home/${fsp_user_name}/script.log"

function hcp_script_log()
{
    local scriptFile="$1";
    local logLevel="$2";
    local logMsg="$3";

    local currentUser=$(whoami | awk '{print $1}')
    local currentOperIP=$(who am i|awk -F' ' '{print $NF}'|grep -o -E "[0-9\.]*");
    if [ "${currentOperIP}" == "" ]; then
        currentOperIP="$(echo ${SSH_CLIENT}|grep -E -o "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])")";
    fi
    local logDateTime=$(date +'%F %T.%N')
    local callDepth=0;
    local funcTrace="${FUNCNAME[@]/hcp_script_log/}";
    funcTrace="$(echo "${funcTrace}"|sed "s#[[:space:]]*main\$##"|sed "s#^[[:space:]]*##")";
    while [ $(echo "${funcTrace}"|grep -E -o "^(log_info|log_error|log_warn|log_debug|log)\>.*"|wc -c) -gt 2 ];
    do
        funcTrace=$(echo "${funcTrace}"|sed -e "s#^\(log_info\|log_error\|log_warn\|log_debug\|log\)\>[[:space:]]*##");
        callDepth=$((callDepth+1));
    done
    funcTrace=$(echo "${funcTrace}"|sed "s#[[:space:]]\{1,\}#<-#g");
    local logformat="";
    logformat="[${logDateTime}][${logLevel}][${currentUser}][${currentOperIP}][${funcTrace}][${scriptFile}][$(caller ${callDepth} | awk '{print $3":"$1}')] ${logMsg}"
    printf "${logformat}\n" >> "${hcp_script_logfile}" 2>&1
}

function log_error()
{
    hcp_script_log "${0##*/}" "ERROR" "$*"
}

function log_info()
{
    hcp_script_log "${0##*/}" "INFO " "$*" 
}

function log_debug()
{
     hcp_script_log "${0##*/}" "DEBUG" "$*"
}

function log_warn()
{
    hcp_script_log "${0##*/}" "WARN " "$*"
}


