#!/bin/bash
set +x

G_PATCH_PKG_VERSION="8.2.0.SPC500"
G_CURRENT_VERSION="8.2.0.SPC300"
G_UPGRADE_PKG="OceanStor BCManager 8.2.0.SPC500_eBackup_Driver"
G_UPGRADE_PKG_NAME="OceanStor BCManager 8.2.0.SPC500_eBackup_Driver.tar.gz"
G_PATCH_VERSION="OceanStor BCManager 8.2.0.SPC500"
G_PATCH_FILE_PATH_PREFIX="cinder"
G_DIRVER_BACKUP_ROOT_DIR=""

fsp_user_name="fsp"
fsp_user_group_name="fsp"
hcp_script_logfile="/home/${fsp_user_name}/script.log"

function hcp_script_log()
{
    local scriptFile="$1";
    local logLevel="$2";
    local logMsg="$3";

    local currentUser=$(whoami | awk '{print $1}')
    local currentOperIP=$(who am i|awk -F' ' '{print $NF}'|grep -o -E "[0-9\.]*");
    if [ "${currentOperIP}" == "" ]; then
        currentOperIP="$(echo ${SSH_CLIENT}|grep -E -o "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])")";
    fi
    local logDateTime=$(date +'%F %T.%N')
    local callDepth=0;
    local funcTrace="${FUNCNAME[@]/hcp_script_log/}";
    funcTrace="$(echo "${funcTrace}"|sed "s#[[:space:]]*main\$##"|sed "s#^[[:space:]]*##")";
    while [ $(echo "${funcTrace}"|grep -E -o "^(log_info|log_error|log_warn|log_debug|log)\>.*"|wc -c) -gt 2 ];
    do
        funcTrace=$(echo "${funcTrace}"|sed -e "s#^\(log_info\|log_error\|log_warn\|log_debug\|log\)\>[[:space:]]*##");
        callDepth=$((callDepth+1));
    done
    funcTrace=$(echo "${funcTrace}"|sed "s#[[:space:]]\{1,\}#<-#g");
    local logformat="";
    logformat="[${logDateTime}][${logLevel}][${currentUser}][${currentOperIP}][${funcTrace}][${scriptFile}][$(caller ${callDepth} | awk '{print $3":"$1}')] ${logMsg}"
    printf "${logformat}\n" >> "${hcp_script_logfile}" 2>&1
}

function log_error()
{
    hcp_script_log "${0##*/}" "ERROR" "$*"
}

function log_info()
{
    hcp_script_log "${0##*/}" "INFO " "$*" 
}

function log_debug()
{
     hcp_script_log "${0##*/}" "DEBUG" "$*"
}

function log_warn()
{
    hcp_script_log "${0##*/}" "WARN " "$*"
}



G_HCP_MAIN_PATH=""
G_DRIVER_VERSION_FILE_PATH=""
G_DJ_ENV_FILE="/etc/huawei/dj/cfg/sys.ini"
G_CINDER_SERVICES_FILE="/tmp/cinder_backup_services_tmp_for_rollback_patch.txt"
G_PATCH_INFO="" #this file save the upgrade file list
G_PATCH_FILE_TXT="/tmp/upgrade/patch_file.txt"

export PATH=$PATH:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/root/bin:/sbin

#******************************************************************#
# Function: usage
# Description: show usage of this scripts
# Input Parameters: N/A
# Returns: N/A
#******************************************************************#
function usage()
{ 
    cat << END                                              
Usage:
    sh patch_rollback.sh rollback_self         Roll back eBackup driver.
END
}

function is_dj_env()
{
    if [ -f ${G_DJ_ENV_FILE} ]; then
        log_info "it is DJ env."
        return 1
    fi
    
    return 0
}

#******************************************************************#
# Function: get_driver_install_path
# Description: Get eBackup driver install path and version file path.
# Input Parameters: 
#   None
# Returns:
#   0 NORMAL
#   1 ERROR
#******************************************************************#
function get_driver_install_path()
{
    G_HCP_MAIN_PATH=""
    G_DRIVER_VERSION_FILE_PATH=""
    if [ -f "/usr/lib/python3.7/site-packages/cinder/backup/drivers/ebackupversion.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib/python3.7/site-packages"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib/python3.7/site-packages/cinder/backup/drivers/ebackupversion.conf"
        return 0
    elif [ -f "/usr/lib/python3.7/site-packages/cinder/backup/drivers/version.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib/python3.7/site-packages"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib/python3.7/site-packages/cinder/backup/drivers/version.conf"
        return 0
    elif [ -f "/usr/lib/python2.7/site-packages/cinder/backup/drivers/ebackupversion.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib/python2.7/site-packages/"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib/python2.7/site-packages/cinder/backup/drivers/ebackupversion.conf"
        return 0
    elif [ -f "/usr/lib/python2.7/site-packages/cinder/backup/drivers/version.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib/python2.7/site-packages/"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib/python2.7/site-packages/cinder/backup/drivers/version.conf"
        return 0
    elif [ -f "/usr/lib64/python2.7/site-packages/cinder/backup/drivers/ebackupversion.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib64/python2.7/site-packages/"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib64/python2.7/site-packages/cinder/backup/drivers/ebackupversion.conf"
        return 0
    elif [ -f "/usr/lib64/python2.7/site-packages/cinder/backup/drivers/version.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib64/python2.7/site-packages/"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib64/python2.7/site-packages/cinder/backup/drivers/version.conf"
        return 0
    elif [ -f "/usr/lib64/python2.6/site-packages/cinder/backup/drivers/ebackupversion.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib64/python2.6/site-packages/"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib64/python2.6/site-packages/cinder/backup/drivers/ebackupversion.conf"
        return 0
    elif [ -f "/usr/lib64/python2.6/site-packages/cinder/backup/drivers/version.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib64/python2.6/site-packages/"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib64/python2.6/site-packages/cinder/backup//drivers/version.conf"
        return 0
    elif [ -f "/usr/lib/python2.6/site-packages/cinder/backup/drivers/ebackupversion.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib/python2.6/site-packages/"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib/python2.6/site-packages/cinder/backup/drivers/ebackupversion.conf"
        return 0
    elif [ -f "/usr/lib/python2.6/site-packages/cinder/backup/drivers/version.conf" ];then
        G_HCP_MAIN_PATH="/usr/lib/python2.6/site-packages/"
        G_DRIVER_VERSION_FILE_PATH="/usr/lib/python2.6/site-packages/cinder/backup/drivers/version.conf"
        return 0
    fi
    
    log_error "This is not eBackup driver node."
    return 1
}

#******************************************************************#
# Function: check_operator
# Description: check current operator is root user or not
# Input Parameters: 
#   NA
# Returns:
#   0 NORMAL
#   1 ERROR
#******************************************************************#
function check_operator()
{
    local L_CUR_USER=`whoami`
    if [ "${L_CUR_USER}" != "root" ]; then
        log_error "The operator user is not root."
        echo -e "\e[0;31;1mError:You have to be root in order to run this script.\e[0m"
        exit 1
    fi
}

#******************************************************************#
# Function: rollback_self
# Description: Roll back self
# Input Parameters: 
#   Null
# Returns:
#   0 NORMAL
#   1 ERROR
#******************************************************************#
function rollback_self()
{
    log_info "Begin roll back..."
    
    check_operator
    
    #get driver install root path
    get_driver_install_path
    if [ $? -ne 0 ];then
        log_error "Current node is not eBackup driver node."
        return 1
    fi
    G_DIRVER_BACKUP_ROOT_DIR="${G_HCP_MAIN_PATH}/cinder/backup/ebackup_driver_backup/${G_CURRENT_VERSION}"
    
    #get patch info file
    local L_INDEX=0
    L_INDEX=$(ls ${G_DIRVER_BACKUP_ROOT_DIR} | grep "^patch.*info$" | awk -F '.' '{print $1}'| awk -F '_' '{print $2}'| sort -n | sed -n '$p')
    if [ "" == "${L_INDEX}" ];then
        L_INDEX=1
    fi
    G_PATCH_INFO="${G_DIRVER_BACKUP_ROOT_DIR}/patch_${L_INDEX}.info"
    if [ ! -f "${G_PATCH_INFO}" ];then
        if [ ! -f "${G_PATCH_FILE_TXT}" ];then
            log_error "The patch info file(${G_PATCH_INFO}) does not exist."
            echo "This node not patched, no need to roll back."
            return 1
        fi
        G_PATCH_INFO="${G_PATCH_FILE_TXT}"
    else
        # version check
        cat "${G_PATCH_INFO}" | egrep "^Version:${G_PATCH_VERSION}\$" >/dev/null 2>&1
        if [ $? -ne 0 ];then
            local L_VERSION_TMP=`cat "${G_PATCH_INFO}" | egrep "^Version:" | awk -F'Version:' '{print $2}' 2>/dev/null`
            log_error "The patched version(${L_VERSION_TMP}) is not match current patch version(${G_PATCH_VERSION})."
            return 1
        fi
    fi
    
    log_info "The patch file is ${G_PATCH_INFO}."
    
    #check process status
    check_service_status
    
    rollback_other_before
    if [ $? -ne 0 ];then
        log_error "Rollback other before failed."
        return 1
    fi
    
    while read line
    do
        if [[ "${line}" =~ ^[:blank:]*\#.* ]];then
            continue
        fi
        
        echo "${line}" | grep "^${G_PATCH_FILE_PATH_PREFIX}" >/dev/null 2>&1
        if [ $? -ne 0 ];then
            continue
        fi
        
        local L_lib=`echo ${line} | awk -F' ' '{print $1}'`
        if [ "X${L_lib}" == "X" ];then
            log_warn "The file(${line}) is empty."
            continue
        fi
        L_lib="${G_HCP_MAIN_PATH}/${L_lib}"
        local L_mode=`echo ${line} | awk -F' ' '{print $5}'`
        
        rollback_copy_file "${L_lib}" "${L_mode}"
        local L_copy_ret=$?
        if [ 0 -ne ${L_copy_ret} ];then
            log_error "Roll back file failed."
            return 1
        fi
    done < ${G_PATCH_INFO}
    
    rollback_other_after
    if [ $? -ne 0 ];then
        log_error "Rollback other after failed."
        return 1
    fi
    
    restart_process
    local L_ret=$?
    rm "${G_CINDER_SERVICES_FILE}" >/dev/null 2>&1
    if [ ${L_ret} -ne 0 ];then
        log_warn "Restart process failed."
    fi
    
    if [ "${G_PATCH_INFO}" != "${G_PATCH_FILE_TXT}" ];then
        log_info "Delete file ${G_PATCH_INFO}."
        rm "${G_PATCH_INFO}" >/dev/null 2>&1
    fi
    
    log_info "Roll back success."
    return 0
}

function rollback_other_before()
{
    log_info "Roll back other."
    
    return 0
}

function rollback_other_after()
{
    log_info "Roll back other."
    
    return 0
}

function rollback_copy_file()
{
    local L_lib="$1"
    local L_lib_backup="${G_DIRVER_BACKUP_ROOT_DIR}/${L_lib}"
    local L_mode="$2"
    
    if [ -f "${L_lib_backup}" ];then
        log_info "rm ${L_lib}."
        rm "${L_lib}" > /dev/null 2>&1

        log_info "Copy ${L_lib_backup} to ${L_lib}."
        cp -af "${L_lib_backup}" "${L_lib}" > /dev/null 2>&1
        if [ $? -ne 0 ];then
            log_error "Copy ${L_lib_backup} to ${L_lib} failed."
            return 1
        fi
        
        return 0
    fi
    
    if [ "new" == "${L_mode}" ];then
        log_info "The file ${L_lib} is new add, need to delete."
        rm "${L_lib}" >/dev/null 2>&1
        return 0
    fi
    
    log_info "The file ${L_lib} has not backup."
    return 0
}

function check_service_status()
{
    > "${G_CINDER_SERVICES_FILE}"
    local L_SERVICE_MODES=""
    L_SERVICE_MODES=`ls /etc/cinder/components_info/|grep "^cinder-backup"`
    if [ $? -ne 0 ];then
        log_warn "there no cinder-backup service."
        return 1
    fi
    
    local L_IS_PASS=0
    for L_SERVICE_MODE in ${L_SERVICE_MODES}
    do
        ps -ef |grep "cinder-backup"|grep "config-file"|grep -E "(${L_SERVICE_MODE}\.conf)|(${L_SERVICE_MODE}_.*\.conf)" >/dev/null 2>&1
        if [ $? != 0 ];then
            log_warn "${L_SERVICE_MODE} is not running."
            continue
        else
            log_info "${L_SERVICE_MODE} is running, but it maybe restart,so we need to check it three times."
            sleep 2
            frist_time_pid=`ps -ef |grep "cinder-backup"|grep "config-file"|grep -E "(${L_SERVICE_MODE}\.conf)|(${L_SERVICE_MODE}_.*\.conf)"|awk '{print $2}'`
            log_info "frist_time_pid:${frist_time_pid}"
            sleep 3
            second_time_pid=`ps -ef |grep "cinder-backup"|grep "config-file"|grep -E "(${L_SERVICE_MODE}\.conf)|(${L_SERVICE_MODE}_.*\.conf)"|awk '{print $2}'` 
            log_info "second_time_pid:${second_time_pid}"
            sleep 3
            third_time_pid=`ps -ef |grep "cinder-backup"|grep "config-file"|grep -E "(${L_SERVICE_MODE}\.conf)|(${L_SERVICE_MODE}_.*\.conf)"|awk '{print $2}'`
            log_info "third_time_pid:${third_time_pid}"
            if [[ $frist_time_pid -eq $second_time_pid ]] && [[ $second_time_pid -eq $third_time_pid ]];then 
               L_IS_PASS=$(expr $L_IS_PASS + 1)
               echo "$L_SERVICE_MODE" >> "${G_CINDER_SERVICES_FILE}"
               log_info "cinder backup(${L_SERVICE_MODE}) is running."
               continue
            else
               log_warn "${L_SERVICE_MODE} is not running."
               continue
            fi
        fi
    done
    if [ ${L_IS_PASS} -eq 0 ];then
        log_warn "There have no cinder backup service is running."
        return 1
    fi
    
    log_info "There have same cinder backup service is running."
    return 0
}

#******************************************************************#
# Function: restart_process
# Description: Restart cinder-backup
# Input Parameters: 
#   Null
# Returns:
#   0 NORMAL
#   1 ERROR
#******************************************************************#
function restart_process()
{
    local L_RET=0
    
    is_dj_env
    L_RET=$?
    if [ ${L_RET} -eq 1 ]; then
        for i in `ps -e | grep "cinder-backup" | awk '{print $1}'`
        do
            kill -9 $i
        done 
    else
        local L_SERVICE_MODES=`cat ${G_CINDER_SERVICES_FILE} 2>/dev/null`
        if [ "" == "${L_SERVICE_MODES}" ];then
            log_error "there no cinder-backup service."
            return 1
        fi
        
        for L_SERVICE_MODE in ${L_SERVICE_MODES}
        do
            log_info "Restart cinder backup service:${L_SERVICE_MODE}."
            ${L_SERVICE_MODE}Control -A RESTART
        done
    fi
    
    ### post check
    check_service_status_verify
    L_RET=$?
    if [ ${L_RET} -ne 0 ]; then
       log_error "check_service_status_verify return failed."
       return ${L_RET}
    fi
    
    log_info "Restart process success."
    return 0
}

function check_service_status_verify()
{
    if [ ! -f "${G_CINDER_SERVICES_FILE}" ];then
        log_error "the ${G_CINDER_SERVICES_FILE} is not exists."
        return 1
    fi
    local L_SERVICE_MODES=`cat ${G_CINDER_SERVICES_FILE} 2>/dev/null`
    if [ "" == "${L_SERVICE_MODES}" ];then
        log_error "there no cinder-backup service." 
        return 1
    fi
    
    local L_CHECK_MAX_TIMES=12
    local L_IS_PASS=0
    local L_serviceNums=0
    for L_SERVICE_MODE in ${L_SERVICE_MODES}
    do
        L_trytime=0
        L_serviceNums=$(expr $L_serviceNums + 1)
        while [[ ${L_trytime} -lt ${L_CHECK_MAX_TIMES} ]]
        do
            ps -ef |grep "cinder-backup"|grep "config-file"|grep -E "(${L_SERVICE_MODE}\.conf)|(${L_SERVICE_MODE}_.*\.conf)" >/dev/null 2>&1
            if [ $? != 0 ];then
                log_error "${L_SERVICE_MODE} is not running, retry ${L_trytime}."
                sleep 5
                L_trytime=$(expr $L_trytime + 1)
                continue
            else
                log_info "${L_SERVICE_MODE} is running, but it maybe restart,so we need to check it three times."
                frist_time_pid=`ps -ef |grep "cinder-backup"|grep "config-file"|grep -E "(${L_SERVICE_MODE}\.conf)|(${L_SERVICE_MODE}_.*\.conf)"|awk '{print $2}'`
                log_info "frist_time_pid:${frist_time_pid}"
                sleep 3
                second_time_pid=`ps -ef |grep "cinder-backup"|grep "config-file"|grep -E "(${L_SERVICE_MODE}\.conf)|(${L_SERVICE_MODE}_.*\.conf)"|awk '{print $2}'` 
                log_info "second_time_pid:${second_time_pid}"
                sleep 3
                third_time_pid=`ps -ef |grep "cinder-backup"|grep "config-file"|grep -E "(${L_SERVICE_MODE}\.conf)|(${L_SERVICE_MODE}_.*\.conf)"|awk '{print $2}'`
                log_info "third_time_pid:${third_time_pid}"
                if [[ $frist_time_pid -eq $second_time_pid ]] && [[ $second_time_pid -eq $third_time_pid ]];then 
                   L_IS_PASS=$(expr $L_IS_PASS + 1)
                   log_info "cinder backup(${L_SERVICE_MODE}) restart success."
                   break
                else
                   sleep 5 
                   L_trytime=$(expr $L_trytime + 1)
                   log_info "L_trytime:${L_trytime}"
                   continue
                fi
            fi
        done
        if [ ${L_trytime} -ge ${L_CHECK_MAX_TIMES} ];then
            log_error "${L_SERVICE_MODE} service is not running."
            return 1
        fi
    done
    if [[ ${L_IS_PASS} -ne ${L_serviceNums} ]];then
        log_error "cinder backup service number is wrong. L_IS_PASS:${L_IS_PASS},L_serviceNums:${L_serviceNums}." 
        return 1
    fi
    
    log_info "cinder backup service verify ok."
    return 0
}

#******************************************************************#
# Function: main
# Description: Main workflow
# Input Parameters: 
#   $1 operation
# Returns:
#   0 NORMAL
#   1 ERROR
#******************************************************************#
function main()
{
    local L_OPERATION=$1
    case "${L_OPERATION}" in
        rollback_self)
            log_info "roll back self"
            echo "Rollbacking, please wait for a moment......"
            rollback_self
            local L_RET=$?
            if [ $L_RET -ne 0 ];then
                log_error "roll back self failed"
                echo "Roll back failed"
                return $L_RET
            fi
            log_info "roll back self success"
            echo "Roll back success"
            ;;
        *)
            echo -e "\e[0;31;1mError:Invalid parameter.\e[0m"
            usage
            log_error "Invalid operation."
            return 1
            ;;
    esac
    
    return 0
}

main $@
exit $?
